// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
if (!window.__IntelliJTools) {
  window.__IntelliJTools = {};
}

window.__IntelliJTools.sendMouseWheelEvent = function (id, x, y, deltaX, deltaY, time, shiftKey, altKey, ctrlKey) {
  let evtInit = {deltaX: deltaX, deltaY: deltaY, clientX: x, clientY: y, bubbles: true, cancelable: true, view: window};
  let el = document.elementFromPoint(x, y);
  if (el === null) {
    return;
  }

  while (el.shadowRoot) {
    let innerEl = el.shadowRoot.elementFromPoint(x, y);
    if (!innerEl || innerEl === el) {
      break;
    }
    el = innerEl;
  }

  let evt = new WheelEvent('wheel', evtInit);
  if (window.__IntelliJTools.sendEvent(el, evt)) {
    return;
  }

  if (window.__IntelliJTools.sendEvent(el, new WheelEvent('mousewheel', evtInit))) {
    return;
  }

  if (el.nodeName === 'CANVAS') {
    return;
  }

  let data = JSON.stringify(
    {
      id: id,
      deltaX: deltaX,
      deltaY: deltaY,
      x: x,
      y: y,
      defaultPrevented: evt.defaultPrevented,
      timeStamp: time,
      altKey: altKey,
      shiftKey: shiftKey,
      ctrlKey: ctrlKey
    }
  );

  let canScrollBrowser = false;
  if (el.nodeName === 'IFRAME') {
    let element = null;
    if (el.contentDocument !== null) {
      element = el.contentDocument.documentElement;
    }

    if (element === null || element === undefined) {
      canScrollBrowser = true;
    }
    else if (element.scrollHeight === element.clientHeight) {
      canScrollBrowser = false;
    }
    else {
      canScrollBrowser = (deltaY > 0 && element.scrollHeight - element.scrollTop - element.clientHeight > 1) ||
        (deltaY < 0 && element.scrollTop > 1);
    }
  }

  if (canScrollBrowser) {
    window.__IntelliJTools.sendWheelEventToCef(data);
  }
  else {
    window.__IntelliJTools.processWheelEvent(data);
  }
};

window.__IntelliJTools.sendEvent = function (el, evt) {
  let isPropagationStopped = false;
  let oStopPropagation = evt.stopPropagation;
  let oStopImmediatePropagation = evt.stopImmediatePropagation;
  evt.stopPropagation = function () {
    isPropagationStopped = true;
    oStopPropagation.apply(this, arguments);
  };
  evt.stopImmediatePropagation = function () {
    isPropagationStopped = true;
    oStopImmediatePropagation.apply(this, arguments);
  };
  el.dispatchEvent(evt);
  return isPropagationStopped;
};
