/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.ChangeKind;
import com.intellij.vcs.log.data.index.CollectionDataExternalizer;
import com.intellij.vcs.log.data.index.IntListDataExternalizer;
import com.intellij.vcs.log.data.index.IntPairKeyDescriptor;
import com.intellij.vcs.log.data.index.LightFilePath;
import com.intellij.vcs.log.data.index.LongPairDataExternalizer;
import com.intellij.vcs.log.data.index.PhmVcsLogStorageBackendKt;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogMessagesTrigramIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogUserIndex;
import com.intellij.vcs.log.data.index.VcsLogWriter;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 s2\u00020\u00012\u00020\u0002:\u0002rsBE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020=H\u0016J\u0014\u0010A\u001a\u00020\u000f2\n\u0010B\u001a\u00060\u001cj\u0002`\u001dH\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020DH\u0016J\u001e\u0010F\u001a\u00020=2\u0006\u0010G\u001a\u00020\u001c2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000f0IH\u0016J\u0016\u0010J\u001a\u0004\u0018\u00010'2\n\u0010B\u001a\u00060\u001cj\u0002`\u001dH\u0016J\u0016\u0010#\u001a\u0004\u0018\u00010\"2\n\u0010B\u001a\u00060\u001cj\u0002`\u001dH\u0016J0\u0010#\u001a\u0018\u0012\b\u0012\u00060\u001cj\u0002`\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0L0K2\u0010\u0010E\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0NH\u0016J\u0016\u0010O\u001a\u0004\u0018\u00010\u001e2\n\u0010B\u001a\u00060\u001cj\u0002`\u001dH\u0016J\"\u0010P\u001a\u00020=2\u0018\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000f0QH\u0016J8\u0010R\u001a\u00020=2\u0006\u0010S\u001a\u00020\u001e2\b\u0010T\u001a\u0004\u0018\u00010D2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001e0V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0016\u0010[\u001a\u0004\u0018\u00010\\2\n\u0010B\u001a\u00060\u001cj\u0002`\u001dH\u0016J\u0016\u0010]\u001a\u0004\u0018\u00010\\2\n\u0010B\u001a\u00060\u001cj\u0002`\u001dH\u0016J\u0016\u0010^\u001a\u00020D2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\\0\bH\u0016JB\u0010_\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010a\u0018\u00010`2\n\u0010b\u001a\u00060\u001cj\u0002`\u001d2\n\u0010c\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010d\u001a\u00020\t2\u0006\u0010e\u001a\u00020a2\u0006\u0010f\u001a\u00020\u000fH\u0016J,\u0010g\u001a\u00020=2\u0006\u0010d\u001a\u00020\t2\u0006\u0010e\u001a\u00020a2\u0012\u0010W\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020i0L0hH\u0016J\b\u0010j\u001a\u00020kH\u0016J\u0017\u0010l\u001a\u00020=2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020=0nH\u0082\bJ\r\u0010o\u001a\u00020=H\u0000\u00a2\u0006\u0002\bpJ\b\u0010q\u001a\u00020=H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u0012\u0012\b\u0012\u00060\u001cj\u0002`\u001d\u0012\u0004\u0012\u00020\u001e0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R$\u0010!\u001a\u0012\u0012\b\u0012\u00060\u001cj\u0002`\u001d\u0012\u0004\u0012\u00020\"0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010 R$\u0010$\u001a\u0012\u0012\b\u0012\u00060\u001cj\u0002`\u001d\u0012\u0004\u0012\u00020\u001c0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010 R$\u0010&\u001a\u0012\u0012\b\u0012\u00060\u001cj\u0002`\u001d\u0012\u0004\u0012\u00020'0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010 R \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010 R\u0014\u0010+\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u001a\u00107\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0014\u0010;\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00108\u00a8\u0006t"}, d2={"Lcom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend;", "Lcom/intellij/vcs/log/data/index/VcsLogStorageBackend;", "Lcom/intellij/openapi/Disposable;", "storageId", "Lcom/intellij/vcs/log/util/StorageId$Directory;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "userRegistry", "Lcom/intellij/vcs/log/VcsUserRegistry;", "errorHandler", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;", "useDurableEnumerator", "", "disposable", "<init>", "(Lcom/intellij/vcs/log/util/StorageId$Directory;Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Set;Lcom/intellij/vcs/log/VcsUserRegistry;Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;ZLcom/intellij/openapi/Disposable;)V", "getStorageId", "()Lcom/intellij/vcs/log/util/StorageId$Directory;", "_container", "Lcom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend$StorageContainer;", "container", "getContainer", "()Lcom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend$StorageContainer;", "messages", "Lcom/intellij/util/io/PersistentHashMap;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "", "getMessages", "()Lcom/intellij/util/io/PersistentHashMap;", "parents", "", "getParents", "committers", "getCommitters", "timestamps", "", "getTimestamps", "renames", "getRenames", "trigrams", "Lcom/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex;", "getTrigrams", "()Lcom/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex;", "paths", "Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex;", "getPaths", "()Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex;", "users", "Lcom/intellij/vcs/log/data/index/VcsLogUserIndex;", "getUsers", "()Lcom/intellij/vcs/log/data/index/VcsLogUserIndex;", "isFresh", "()Z", "setFresh", "(Z)V", "isEmpty", "reportEmpty", "", "createWriter", "Lcom/intellij/vcs/log/data/index/VcsLogWriter;", "markCorrupted", "containsCommit", "commitId", "collectMissingCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "commitIds", "iterateIndexedCommits", "limit", "processor", "Ljava/util/function/IntFunction;", "getTimestamp", "", "", "Lcom/intellij/vcs/log/Hash;", "", "getMessage", "processMessages", "Lkotlin/Function2;", "getCommitsForSubstring", "string", "candidates", "noTrigramSources", "", "consumer", "Ljava/util/function/IntConsumer;", "filter", "Lcom/intellij/vcs/log/VcsLogTextFilter;", "getAuthorForCommit", "Lcom/intellij/vcs/log/VcsUser;", "getCommitterForCommit", "getCommitsForUsers", "findRename", "Lcom/intellij/vcs/log/history/EdgeData;", "Lcom/intellij/openapi/vcs/FilePath;", "parent", "child", "root", "path", "isChildPath", "iterateChangesInCommits", "Ljava/util/function/ObjIntConsumer;", "Lcom/intellij/vcs/log/data/index/ChangeKind;", "getPathsEncoder", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$PathsEncoder;", "catchAndWarn", "runnable", "Lkotlin/Function0;", "clearCaches", "clearCaches$intellij_platform_vcs_log_impl", "dispose", "StorageContainer", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nPhmVcsLogStorageBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhmVcsLogStorageBackend.kt\ncom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,444:1\n351#1,9:458\n351#1,9:467\n351#1,9:476\n351#1,9:485\n351#1,9:494\n1617#2,9:445\n1869#2:454\n1870#2:456\n1626#2:457\n1#3:455\n*S KotlinDebug\n*F\n+ 1 PhmVcsLogStorageBackend.kt\ncom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend\n*L\n96#1:458,9\n107#1:467,9\n118#1:476,9\n129#1:485,9\n138#1:494,9\n255#1:445,9\n255#1:454\n255#1:456\n255#1:457\n255#1:455\n*E\n"})
public final class PhmVcsLogStorageBackend
implements VcsLogStorageBackend,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StorageId.Directory storageId;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final VcsLogErrorHandler errorHandler;
    @Nullable
    private StorageContainer _container;
    private volatile boolean isFresh;
    @NotNull
    private static final Logger LOG;
    @NonNls
    @NotNull
    private static final String INDEX = "index";
    private static final int VERSION = 3;

    public PhmVcsLogStorageBackend(@NotNull StorageId.Directory storageId, @NotNull VcsLogStorage storage, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsUserRegistry userRegistry, @NotNull VcsLogErrorHandler errorHandler, boolean useDurableEnumerator, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)userRegistry, (String)"userRegistry");
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.storageId = storageId;
        this.storage = storage;
        this.errorHandler = errorHandler;
        Disposer.register((Disposable)disposable, (Disposable)this);
        try {
            StorageLockContext storageLockContext = new StorageLockContext();
            Path messagesStorage = StorageId.Directory.getStorageFile$default(this.getStorageId(), "messages", false, 2, null);
            this.setFresh(!Files.exists(messagesStorage, new LinkOption[0]));
            PersistentHashMap messages = new PersistentHashMap(messagesStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorStringDescriptor.INSTANCE, AbstractStorage.PAGE_SIZE, this.getStorageId().getVersion(), storageLockContext);
            Disposer.register((Disposable)this, () -> PhmVcsLogStorageBackend._init_$lambda$0(this, messages));
            Path parentsStorage = StorageId.Directory.getStorageFile$default(this.getStorageId(), "parents", false, 2, null);
            PersistentHashMap parents = new PersistentHashMap(parentsStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntListDataExternalizer(), AbstractStorage.PAGE_SIZE, this.getStorageId().getVersion(), storageLockContext);
            Disposer.register((Disposable)this, () -> PhmVcsLogStorageBackend._init_$lambda$2(this, parents));
            Path committerStorage = StorageId.Directory.getStorageFile$default(this.getStorageId(), "committers", false, 2, null);
            PersistentHashMap committers = new PersistentHashMap(committerStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE, AbstractStorage.PAGE_SIZE, this.getStorageId().getVersion(), storageLockContext);
            Disposer.register((Disposable)this, () -> PhmVcsLogStorageBackend._init_$lambda$4(this, committers));
            Path timestampsStorage = StorageId.Directory.getStorageFile$default(this.getStorageId(), "timestamps", false, 2, null);
            PersistentHashMap timestamps = new PersistentHashMap(timestampsStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new LongPairDataExternalizer(), AbstractStorage.PAGE_SIZE, this.getStorageId().getVersion(), storageLockContext);
            Disposer.register((Disposable)this, () -> PhmVcsLogStorageBackend._init_$lambda$6(this, timestamps));
            Path storageFile = StorageId.Directory.getStorageFile$default(this.getStorageId(), "renames-map", false, 2, null);
            PersistentHashMap renames = new PersistentHashMap(storageFile, (KeyDescriptor)IntPairKeyDescriptor.INSTANCE, (DataExternalizer)CollectionDataExternalizer.INSTANCE, AbstractStorage.PAGE_SIZE, this.getStorageId().getVersion(), storageLockContext);
            Disposer.register((Disposable)this, () -> PhmVcsLogStorageBackend._init_$lambda$8(this, renames));
            VcsLogPathsIndex vcsLogPathsIndex = VcsLogPathsIndex.create(this.getStorageId(), storageLockContext, this.storage, roots, (PersistentHashMap<int[], int[]>)renames, useDurableEnumerator, this.errorHandler, this);
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogPathsIndex, (String)"create(...)");
            VcsLogPathsIndex paths = vcsLogPathsIndex;
            VcsLogUserIndex vcsLogUserIndex = VcsLogUserIndex.create(this.getStorageId(), storageLockContext, userRegistry, this.errorHandler, this);
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogUserIndex, (String)"create(...)");
            VcsLogUserIndex users = vcsLogUserIndex;
            VcsLogMessagesTrigramIndex trigrams = new VcsLogMessagesTrigramIndex(this.getStorageId(), storageLockContext, this.errorHandler, this);
            this._container = new StorageContainer((PersistentHashMap<Integer, String>)messages, (PersistentHashMap<Integer, int[]>)parents, (PersistentHashMap<Integer, Integer>)committers, (PersistentHashMap<Integer, long[]>)timestamps, (PersistentHashMap<int[], int[]>)renames, trigrams, paths, users);
            this.reportEmpty();
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)this);
            throw t;
        }
    }

    @Override
    @NotNull
    public StorageId.Directory getStorageId() {
        return this.storageId;
    }

    private final StorageContainer getContainer() {
        StorageContainer storageContainer = this._container;
        if (storageContainer == null) {
            throw new IllegalStateException(("Storage is closed: " + this.getStorageId()).toString());
        }
        return storageContainer;
    }

    private final PersistentHashMap<Integer, String> getMessages() {
        return this.getContainer().getMessages();
    }

    private final PersistentHashMap<Integer, int[]> getParents() {
        return this.getContainer().getParents();
    }

    private final PersistentHashMap<Integer, Integer> getCommitters() {
        return this.getContainer().getCommitters();
    }

    private final PersistentHashMap<Integer, long[]> getTimestamps() {
        return this.getContainer().getTimestamps();
    }

    private final PersistentHashMap<int[], int[]> getRenames() {
        return this.getContainer().getRenames();
    }

    private final VcsLogMessagesTrigramIndex getTrigrams() {
        return this.getContainer().getTrigrams();
    }

    private final VcsLogPathsIndex getPaths() {
        return this.getContainer().getPaths();
    }

    private final VcsLogUserIndex getUsers() {
        return this.getContainer().getUsers();
    }

    @Override
    public boolean isFresh() {
        return this.isFresh;
    }

    @Override
    public void setFresh(boolean bl) {
        this.isFresh = bl;
    }

    @Override
    public boolean isEmpty() {
        return this.getMessages().keysCountApproximately() == 0;
    }

    private final void reportEmpty() throws IOException {
        if (this.getMessages().keysCountApproximately() == 0) {
            return;
        }
        boolean trigramsEmpty = this.getTrigrams().isEmpty();
        boolean usersEmpty = this.getUsers().isEmpty();
        boolean pathsEmpty = this.getPaths().isEmpty();
        if (trigramsEmpty || usersEmpty || pathsEmpty) {
            VcsLogPersistentIndex.LOG.warn("Some of the index maps empty:\ntrigrams empty " + trigramsEmpty + "\nusers empty " + usersEmpty + "\npaths empty " + pathsEmpty);
        }
    }

    @Override
    @NotNull
    public VcsLogWriter createWriter() {
        return new VcsLogWriter(this){
            final /* synthetic */ PhmVcsLogStorageBackend this$0;
            {
                this.this$0 = $receiver;
            }

            public void putCommit(int commitId, VcsLogIndexer.CompressedDetails details) {
                Intrinsics.checkNotNullParameter((Object)details, (String)"details");
                PhmVcsLogStorageBackend.access$getUsers(this.this$0).update(commitId, details);
                PhmVcsLogStorageBackend.access$getPaths(this.this$0).update(commitId, details);
                PhmVcsLogStorageBackend.access$getTrigrams(this.this$0).update(commitId, details);
                int n = 0;
                int n2 = details.getParents().size();
                int[] nArray = new int[n2];
                Integer n3 = commitId;
                PersistentHashMap persistentHashMap = PhmVcsLogStorageBackend.access$getParents(this.this$0);
                while (n < n2) {
                    int n4 = n++;
                    VcsLogStorage vcsLogStorage = PhmVcsLogStorageBackend.access$getStorage$p(this.this$0);
                    E e = details.getParents().get(n4);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    Hash hash = (Hash)e;
                    VirtualFile virtualFile = details.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    nArray[n4] = vcsLogStorage.getCommitIndex(hash, virtualFile);
                }
                persistentHashMap.put((Object)n3, (Object)nArray);
                long[] lArray = new long[]{details.getAuthorTime(), details.getCommitTime()};
                PhmVcsLogStorageBackend.access$getTimestamps(this.this$0).put((Object)commitId, (Object)lArray);
                if (!Intrinsics.areEqual((Object)details.getAuthor(), (Object)details.getCommitter())) {
                    PhmVcsLogStorageBackend.access$getCommitters(this.this$0).put((Object)commitId, (Object)PhmVcsLogStorageBackend.access$getUsers(this.this$0).getUserId(details.getCommitter()));
                }
                PhmVcsLogStorageBackend.access$getMessages(this.this$0).put((Object)commitId, (Object)details.getFullMessage());
            }

            private final void force() {
                try {
                    PhmVcsLogStorageBackend.access$getParents(this.this$0).force();
                    PhmVcsLogStorageBackend.access$getCommitters(this.this$0).force();
                    PhmVcsLogStorageBackend.access$getTimestamps(this.this$0).force();
                    PhmVcsLogStorageBackend.access$getTrigrams(this.this$0).flush();
                    PhmVcsLogStorageBackend.access$getUsers(this.this$0).flush();
                    PhmVcsLogStorageBackend.access$getPaths(this.this$0).flush();
                    PhmVcsLogStorageBackend.access$getMessages(this.this$0).force();
                }
                catch (IOException e) {
                    PhmVcsLogStorageBackend.access$getErrorHandler$p(this.this$0).handleError(VcsLogErrorHandler.Source.Index, e);
                }
                catch (StorageException s) {
                    PhmVcsLogStorageBackend.access$getErrorHandler$p(this.this$0).handleError(VcsLogErrorHandler.Source.Index, s);
                }
            }

            public void flush() {
                this.force();
            }

            public void close(boolean performCommit) {
                this.force();
            }

            public void interrupt() {
                this.force();
            }
        };
    }

    @Override
    public void markCorrupted() {
        try {
            this.getMessages().markCorrupted();
            this.getMessages().force();
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    @Override
    public boolean containsCommit(int commitId) {
        return this.getMessages().containsMapping((Object)commitId);
    }

    @Override
    @NotNull
    public IntSet collectMissingCommits(@NotNull IntSet commitIds2) {
        Intrinsics.checkNotNullParameter((Object)commitIds2, (String)"commitIds");
        IntOpenHashSet missing = new IntOpenHashSet();
        commitIds2.forEach(arg_0 -> PhmVcsLogStorageBackend.collectMissingCommits$lambda$9(this, missing, arg_0));
        return (IntSet)missing;
    }

    @Override
    public void iterateIndexedCommits(int limit, @NotNull IntFunction<Boolean> processor) throws IOException {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Ref.IntRef iterationCount = new Ref.IntRef();
        this.getMessages().processKeysWithExistingMapping(arg_0 -> PhmVcsLogStorageBackend.iterateIndexedCommits$lambda$11(arg_0 -> PhmVcsLogStorageBackend.iterateIndexedCommits$lambda$10(iterationCount, limit, processor, arg_0), arg_0));
    }

    @Override
    @Nullable
    public long[] getTimestamp(int commitId) {
        return (long[])this.getTimestamps().get((Object)commitId);
    }

    @Override
    @Nullable
    public int[] getParents(int commitId) {
        return (int[])this.getParents().get((Object)commitId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Integer, List<Hash>> getParents(@NotNull Collection<Integer> commitIds2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(commitIds2, (String)"commitIds");
        Iterable $this$mapNotNull$iv = commitIds2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            List<Hash> parentHashes;
            int[] parents;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            int commitId = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if ((this.getParents(commitId) == null ? null : (PhmVcsLogStorageBackendKt.getHashes(this.storage, parents) == null ? null : TuplesKt.to((Object)commitId, parentHashes))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Override
    @Nullable
    public String getMessage(int commitId) {
        return (String)this.getMessages().get((Object)commitId);
    }

    @Override
    public void processMessages(@NotNull Function2<? super Integer, ? super String, Boolean> processor) throws IOException {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        this.getMessages().processKeysWithExistingMapping(arg_0 -> PhmVcsLogStorageBackend.processMessages$lambda$13(processor, this, arg_0));
    }

    @Override
    public void getCommitsForSubstring(@NotNull String string, @Nullable IntSet candidates, @NotNull List<String> noTrigramSources, @NotNull IntConsumer consumer, @NotNull VcsLogTextFilter filter) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter(noTrigramSources, (String)"noTrigramSources");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        IntSet commits = this.getTrigrams().getCommitsForSubstring(string);
        if (commits == null) {
            noTrigramSources.add(string);
            return;
        }
        IntIterator intIterator = commits.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator = intIterator;
        while (iterator.hasNext()) {
            String message;
            int commit = iterator.nextInt();
            if (candidates != null && !candidates.contains(commit) || (message = (String)this.getMessages().get((Object)commit)) == null || !filter.matches(message)) continue;
            consumer.accept(commit);
        }
    }

    @Override
    @Nullable
    public VcsUser getAuthorForCommit(int commitId) {
        return this.getUsers().getAuthorForCommit(commitId);
    }

    @Override
    @Nullable
    public VcsUser getCommitterForCommit(int commitId) {
        Integer committer = (Integer)this.getCommitters().get((Object)commitId);
        if (committer != null) {
            return this.getUsers().getUserById(committer);
        }
        return this.getMessages().containsMapping((Object)commitId) ? this.getAuthorForCommit(commitId) : null;
    }

    @Override
    @NotNull
    public IntSet getCommitsForUsers(@NotNull Set<? extends VcsUser> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        IntSet intSet = this.getUsers().getCommitsForUsers(users);
        Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"getCommitsForUsers(...)");
        return intSet;
    }

    @Override
    @Nullable
    public EdgeData<FilePath> findRename(int parent, int child, @NotNull VirtualFile root, @NotNull FilePath path, boolean isChildPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int[] nArray = new int[]{parent, child};
        int[] renames = (int[])this.getRenames().get((Object)nArray);
        if (renames == null || renames.length == 0) {
            return null;
        }
        int pathId = this.getPaths().getPathId(new LightFilePath(root, path));
        for (int i = 0; i < renames.length; i += 2) {
            int first = renames[i];
            int second = renames[i + 1];
            if ((!isChildPath || second != pathId) && (isChildPath || first != pathId)) continue;
            FilePath path1 = this.getPaths().getPath(first, path.isDirectory());
            FilePath path2 = this.getPaths().getPath(second, path.isDirectory());
            return new EdgeData<FilePath>(path1, path2);
        }
        return null;
    }

    @Override
    public void iterateChangesInCommits(@NotNull VirtualFile root, @NotNull FilePath path, @NotNull ObjIntConsumer<List<ChangeKind>> consumer) throws IOException, StorageException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        int pathId = this.getPaths().getPathId(new LightFilePath(root, path));
        this.getPaths().iterateCommitIdsAndValues(pathId, consumer);
    }

    @Override
    @NotNull
    public VcsLogIndexer.PathsEncoder getPathsEncoder() {
        return (arg_0, arg_1, arg_2) -> PhmVcsLogStorageBackend.getPathsEncoder$lambda$14(this, arg_0, arg_1, arg_2);
    }

    private final void catchAndWarn(Function0<Unit> runnable) {
        boolean $i$f$catchAndWarn = false;
        try {
            runnable.invoke();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    public final void clearCaches$intellij_platform_vcs_log_impl() {
        Object[] objectArray = new VcsLogFullDetailsIndex[]{this.getTrigrams(), this.getPaths(), this.getUsers()};
        for (VcsLogFullDetailsIndex index : CollectionsKt.listOf((Object[])objectArray)) {
            index.clearCaches();
        }
    }

    public void dispose() {
        this._container = null;
    }

    private static final void _init_$lambda$0(PhmVcsLogStorageBackend this$0, PersistentHashMap $messages) {
        PhmVcsLogStorageBackend this_$iv = this$0;
        boolean $i$f$catchAndWarn = false;
        try {
            boolean bl = false;
            $messages.close();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable t$iv) {
            LOG.warn(t$iv);
        }
    }

    private static final void _init_$lambda$2(PhmVcsLogStorageBackend this$0, PersistentHashMap $parents) {
        PhmVcsLogStorageBackend this_$iv = this$0;
        boolean $i$f$catchAndWarn = false;
        try {
            boolean bl = false;
            $parents.close();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable t$iv) {
            LOG.warn(t$iv);
        }
    }

    private static final void _init_$lambda$4(PhmVcsLogStorageBackend this$0, PersistentHashMap $committers) {
        PhmVcsLogStorageBackend this_$iv = this$0;
        boolean $i$f$catchAndWarn = false;
        try {
            boolean bl = false;
            $committers.close();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable t$iv) {
            LOG.warn(t$iv);
        }
    }

    private static final void _init_$lambda$6(PhmVcsLogStorageBackend this$0, PersistentHashMap $timestamps) {
        PhmVcsLogStorageBackend this_$iv = this$0;
        boolean $i$f$catchAndWarn = false;
        try {
            boolean bl = false;
            $timestamps.close();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable t$iv) {
            LOG.warn(t$iv);
        }
    }

    private static final void _init_$lambda$8(PhmVcsLogStorageBackend this$0, PersistentHashMap $renames) {
        PhmVcsLogStorageBackend this_$iv = this$0;
        boolean $i$f$catchAndWarn = false;
        try {
            boolean bl = false;
            $renames.close();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable t$iv) {
            LOG.warn(t$iv);
        }
    }

    private static final void collectMissingCommits$lambda$9(PhmVcsLogStorageBackend this$0, IntOpenHashSet $missing, int it) {
        if (!this$0.getMessages().containsMapping((Object)it)) {
            $missing.add(it);
        }
    }

    private static final boolean iterateIndexedCommits$lambda$10(Ref.IntRef $iterationCount, int $limit, IntFunction $processor, Integer it) {
        if ($iterationCount.element >= $limit) {
            return false;
        }
        int n = $iterationCount.element;
        $iterationCount.element = n + 1;
        Intrinsics.checkNotNull((Object)it);
        Object r = $processor.apply(it);
        Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
        return (Boolean)r;
    }

    private static final boolean iterateIndexedCommits$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processMessages$lambda$13(Function2 $processor, PhmVcsLogStorageBackend this$0, Integer commit) {
        Intrinsics.checkNotNull((Object)commit);
        String string = (String)this$0.getMessages().get((Object)commit);
        if (string == null) {
            return true;
        }
        return (Boolean)$processor.invoke((Object)commit, (Object)string);
    }

    private static final int getPathsEncoder$lambda$14(PhmVcsLogStorageBackend this$0, VirtualFile root, String relativePath, boolean bl) {
        int n;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        try {
            n = this$0.getPaths().getPathId(new LightFilePath(root, relativePath));
        }
        catch (IOException e) {
            this$0.errorHandler.handleError(VcsLogErrorHandler.Source.Index, e);
            return 0;
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final PhmVcsLogStorageBackend create(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull StorageId.Directory indexStorageId, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsLogErrorHandler errorHandler, @NotNull Disposable parent) throws IOException {
        return Companion.create(project, storage, indexStorageId, roots, errorHandler, parent);
    }

    @JvmStatic
    @NotNull
    public static final StorageId.Directory getIndexStorageId(@NotNull Project project, @NotNull String logId) {
        return Companion.getIndexStorageId(project, logId);
    }

    public static final /* synthetic */ VcsLogUserIndex access$getUsers(PhmVcsLogStorageBackend $this) {
        return $this.getUsers();
    }

    public static final /* synthetic */ VcsLogPathsIndex access$getPaths(PhmVcsLogStorageBackend $this) {
        return $this.getPaths();
    }

    public static final /* synthetic */ VcsLogMessagesTrigramIndex access$getTrigrams(PhmVcsLogStorageBackend $this) {
        return $this.getTrigrams();
    }

    public static final /* synthetic */ PersistentHashMap access$getParents(PhmVcsLogStorageBackend $this) {
        return $this.getParents();
    }

    public static final /* synthetic */ VcsLogStorage access$getStorage$p(PhmVcsLogStorageBackend $this) {
        return $this.storage;
    }

    public static final /* synthetic */ PersistentHashMap access$getTimestamps(PhmVcsLogStorageBackend $this) {
        return $this.getTimestamps();
    }

    public static final /* synthetic */ PersistentHashMap access$getCommitters(PhmVcsLogStorageBackend $this) {
        return $this.getCommitters();
    }

    public static final /* synthetic */ PersistentHashMap access$getMessages(PhmVcsLogStorageBackend $this) {
        return $this.getMessages();
    }

    public static final /* synthetic */ VcsLogErrorHandler access$getErrorHandler$p(PhmVcsLogStorageBackend $this) {
        return $this.errorHandler;
    }

    static {
        Logger logger = Logger.getInstance(PhmVcsLogStorageBackend.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\bH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "INDEX", "", "VERSION", "", "durableEnumeratorRegistryProperty", "Lcom/intellij/openapi/util/registry/RegistryValue;", "getDurableEnumeratorRegistryProperty$intellij_platform_vcs_log_impl", "()Lcom/intellij/openapi/util/registry/RegistryValue;", "create", "Lcom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "indexStorageId", "Lcom/intellij/vcs/log/util/StorageId$Directory;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "errorHandler", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;", "parent", "Lcom/intellij/openapi/Disposable;", "getIndexStorageId", "logId", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RegistryValue getDurableEnumeratorRegistryProperty$intellij_platform_vcs_log_impl() {
            return Registry.Companion.get("vcs.log.index.durable.enumerator");
        }

        @JvmStatic
        @NotNull
        public final PhmVcsLogStorageBackend create(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull StorageId.Directory indexStorageId, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsLogErrorHandler errorHandler, @NotNull Disposable parent) throws IOException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter((Object)indexStorageId, (String)"indexStorageId");
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            VcsUserRegistry userRegistry = (VcsUserRegistry)project.getService(VcsUserRegistry.class);
            boolean useDurableEnumerator = this.getDurableEnumeratorRegistryProperty$intellij_platform_vcs_log_impl().asBoolean();
            Object object = IOUtil.openCleanOrResetBroken(() -> Companion.create$lambda$0(indexStorageId, storage, roots, userRegistry, errorHandler, useDurableEnumerator, parent), () -> Companion.create$lambda$1(indexStorageId));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"openCleanOrResetBroken(...)");
            return (PhmVcsLogStorageBackend)object;
        }

        @JvmStatic
        @NotNull
        public final StorageId.Directory getIndexStorageId(@NotNull Project project, @NotNull String logId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
            String string = project.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return new StorageId.Directory(string, PhmVcsLogStorageBackend.INDEX, logId, 29);
        }

        private static final PhmVcsLogStorageBackend create$lambda$0(StorageId.Directory $indexStorageId, VcsLogStorage $storage, Set $roots, VcsUserRegistry $userRegistry, VcsLogErrorHandler $errorHandler, boolean $useDurableEnumerator, Disposable $parent) {
            Intrinsics.checkNotNull((Object)$userRegistry);
            return new PhmVcsLogStorageBackend($indexStorageId, $storage, $roots, $userRegistry, $errorHandler, $useDurableEnumerator, $parent);
        }

        private static final void create$lambda$1(StorageId.Directory $indexStorageId) {
            if (!$indexStorageId.cleanupAllStorageFiles()) {
                LOG.error("Could not clean up storage files in " + $indexStorageId.getStoragePath());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B\u0093\u0001\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0016\u0010\n\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u000b0\u0003\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0007\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R!\u0010\t\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R!\u0010\n\u001a\u0012\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/intellij/vcs/log/data/index/PhmVcsLogStorageBackend$StorageContainer;", "", "messages", "Lcom/intellij/util/io/PersistentHashMap;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "", "parents", "", "committers", "timestamps", "", "renames", "trigrams", "Lcom/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex;", "paths", "Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex;", "users", "Lcom/intellij/vcs/log/data/index/VcsLogUserIndex;", "<init>", "(Lcom/intellij/util/io/PersistentHashMap;Lcom/intellij/util/io/PersistentHashMap;Lcom/intellij/util/io/PersistentHashMap;Lcom/intellij/util/io/PersistentHashMap;Lcom/intellij/util/io/PersistentHashMap;Lcom/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex;Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex;Lcom/intellij/vcs/log/data/index/VcsLogUserIndex;)V", "getMessages", "()Lcom/intellij/util/io/PersistentHashMap;", "getParents", "getCommitters", "getTimestamps", "getRenames", "getTrigrams", "()Lcom/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex;", "getPaths", "()Lcom/intellij/vcs/log/data/index/VcsLogPathsIndex;", "getUsers", "()Lcom/intellij/vcs/log/data/index/VcsLogUserIndex;", "intellij.platform.vcs.log.impl"})
    private static final class StorageContainer {
        @NotNull
        private final PersistentHashMap<Integer, String> messages;
        @NotNull
        private final PersistentHashMap<Integer, int[]> parents;
        @NotNull
        private final PersistentHashMap<Integer, Integer> committers;
        @NotNull
        private final PersistentHashMap<Integer, long[]> timestamps;
        @NotNull
        private final PersistentHashMap<int[], int[]> renames;
        @NotNull
        private final VcsLogMessagesTrigramIndex trigrams;
        @NotNull
        private final VcsLogPathsIndex paths;
        @NotNull
        private final VcsLogUserIndex users;

        public StorageContainer(@NotNull PersistentHashMap<Integer, String> messages, @NotNull PersistentHashMap<Integer, int[]> parents, @NotNull PersistentHashMap<Integer, Integer> committers, @NotNull PersistentHashMap<Integer, long[]> timestamps, @NotNull PersistentHashMap<int[], int[]> renames, @NotNull VcsLogMessagesTrigramIndex trigrams, @NotNull VcsLogPathsIndex paths, @NotNull VcsLogUserIndex users) {
            Intrinsics.checkNotNullParameter(messages, (String)"messages");
            Intrinsics.checkNotNullParameter(parents, (String)"parents");
            Intrinsics.checkNotNullParameter(committers, (String)"committers");
            Intrinsics.checkNotNullParameter(timestamps, (String)"timestamps");
            Intrinsics.checkNotNullParameter(renames, (String)"renames");
            Intrinsics.checkNotNullParameter((Object)trigrams, (String)"trigrams");
            Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
            Intrinsics.checkNotNullParameter((Object)users, (String)"users");
            this.messages = messages;
            this.parents = parents;
            this.committers = committers;
            this.timestamps = timestamps;
            this.renames = renames;
            this.trigrams = trigrams;
            this.paths = paths;
            this.users = users;
        }

        @NotNull
        public final PersistentHashMap<Integer, String> getMessages() {
            return this.messages;
        }

        @NotNull
        public final PersistentHashMap<Integer, int[]> getParents() {
            return this.parents;
        }

        @NotNull
        public final PersistentHashMap<Integer, Integer> getCommitters() {
            return this.committers;
        }

        @NotNull
        public final PersistentHashMap<Integer, long[]> getTimestamps() {
            return this.timestamps;
        }

        @NotNull
        public final PersistentHashMap<int[], int[]> getRenames() {
            return this.renames;
        }

        @NotNull
        public final VcsLogMessagesTrigramIndex getTrigrams() {
            return this.trigrams;
        }

        @NotNull
        public final VcsLogPathsIndex getPaths() {
            return this.paths;
        }

        @NotNull
        public final VcsLogUserIndex getUsers() {
            return this.users;
        }
    }
}

