/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.ignore;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.ignore.FileIterationListener;
import org.jetbrains.idea.svn.ignore.IgnoreInfoGetter;

public class FileGroupInfo
implements FileIterationListener,
IgnoreInfoGetter {
    private String commonExtension;
    private final Map<VirtualFile, Set<String>> folders = new HashMap<VirtualFile, Set<String>>();
    private int fileCount = 0;
    private boolean sameExtensionCase = true;

    @Override
    public void onFileEnabled(VirtualFile file) {
        VirtualFile parentVirtualFile;
        ++this.fileCount;
        if (this.sameExtensionCase) {
            String extension = file.getExtension();
            if (extension == null) {
                this.sameExtensionCase = false;
            } else if (this.commonExtension == null) {
                this.commonExtension = extension;
            } else {
                this.sameExtensionCase &= this.commonExtension.equals(extension);
            }
        }
        if ((parentVirtualFile = file.getParent()) != null) {
            Set<String> namesList = this.folders.get(parentVirtualFile);
            if (namesList == null) {
                namesList = new HashSet<String>();
                this.folders.put(parentVirtualFile, namesList);
            }
            namesList.add(file.getName());
        }
    }

    public boolean oneFileSelected() {
        return this.fileCount == 1;
    }

    public boolean sameExtension() {
        return this.sameExtensionCase;
    }

    @NlsSafe
    @NotNull
    public String getExtensionMask() {
        String string = "*." + this.commonExtension;
        if (string == null) {
            FileGroupInfo.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public Map<VirtualFile, Set<String>> getInfo(boolean useCommonExtension) {
        if (!useCommonExtension) {
            return this.folders;
        }
        HashMap<VirtualFile, Set<String>> result = new HashMap<VirtualFile, Set<String>>(this.folders.size(), 1.0f);
        for (Map.Entry<VirtualFile, Set<String>> entry : this.folders.entrySet()) {
            HashSet<String> set = new HashSet<String>();
            set.add(this.getExtensionMask());
            result.put(entry.getKey(), set);
        }
        return result;
    }

    @NlsSafe
    @NotNull
    public String getFileName() {
        String string = this.folders.values().iterator().next().iterator().next();
        if (string == null) {
            FileGroupInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/svn/ignore/FileGroupInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionMask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

