/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.coverage;

import com.intellij.coverage.CoverageLoadingListener;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.coverage.SuccessCoverageLoadingResult;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaMessageReporter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\bH\u0016J(\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\b2\u000e\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015H\u0016J*\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00122\u0010\b\u0002\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/QodanaCoverageLoadingListener;", "Lcom/intellij/coverage/CoverageLoadingListener;", "<init>", "()V", "reporter", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaMessageReporter$DEFAULT;", "reportedErrors", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/io/File;", "Ljava/util/concurrent/atomic/AtomicInteger;", "coverageLoadingStarted", "", "coverageFile", "reportCoverageLoaded", "result", "Lcom/intellij/coverage/CoverageLoadingResult;", "reportCoverageLoadException", "reason", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "reportError", "message", "Companion", "intellij.qodana.coverage"})
@SourceDebugExtension(value={"SMAP\nQodanaCoverageLoadingListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaCoverageLoadingListener.kt\norg/jetbrains/qodana/staticAnalysis/inspections/coverage/QodanaCoverageLoadingListener\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n72#2,2:53\n1#3:55\n1#3:56\n*S KotlinDebug\n*F\n+ 1 QodanaCoverageLoadingListener.kt\norg/jetbrains/qodana/staticAnalysis/inspections/coverage/QodanaCoverageLoadingListener\n*L\n42#1:53,2\n42#1:55\n*E\n"})
public final class QodanaCoverageLoadingListener
implements CoverageLoadingListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QodanaMessageReporter.DEFAULT reporter = QodanaMessageReporter.DEFAULT.INSTANCE;
    @NotNull
    private final ConcurrentHashMap<File, AtomicInteger> reportedErrors = new ConcurrentHashMap();

    public void coverageLoadingStarted(@NotNull File coverageFile) {
        Intrinsics.checkNotNullParameter((Object)coverageFile, (String)"coverageFile");
        this.reporter.reportMessage(1, "Started loading coverage from " + coverageFile + "...");
    }

    public void reportCoverageLoaded(@NotNull CoverageLoadingResult result2, @NotNull File coverageFile) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)coverageFile, (String)"coverageFile");
        CoverageLoadingResult coverageLoadingResult = result2;
        if (coverageLoadingResult instanceof FailedCoverageLoadingResult) {
            this.reportError(coverageFile, "Could not load coverage from file " + coverageFile + ": " + ((FailedCoverageLoadingResult)result2).getReason(), ((FailedCoverageLoadingResult)result2).getException());
        } else if (coverageLoadingResult instanceof SuccessCoverageLoadingResult) {
            this.reporter.reportMessage(1, "Coverage from file " + coverageFile + " loaded successfully.");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void reportCoverageLoadException(@NotNull String reason, @NotNull File coverageFile, @Nullable Exception e) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter((Object)coverageFile, (String)"coverageFile");
        String message = "The coverage data from " + coverageFile + " may be loaded incorrectly because of: " + reason;
        this.reportError(coverageFile, message, e);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportError(File coverageFile, String message, Exception e) {
        AtomicInteger problemCounter;
        int currentProblemCount;
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.reportedErrors;
        File key$iv = coverageFile;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            AtomicInteger default$iv = new AtomicInteger(0);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        if ((currentProblemCount = (problemCounter = (AtomicInteger)object).incrementAndGet()) <= 10) {
            this.reporter.reportError(message);
            Exception exception = e;
            if (exception != null) {
                Exception it = exception;
                boolean bl = false;
                this.reporter.reportError(it);
            }
        }
        if (currentProblemCount == 11) {
            String string = coverageFile.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.reporter.reportError(Companion.buildTooManyErrorMessage(string));
        }
    }

    static /* synthetic */ void reportError$default(QodanaCoverageLoadingListener qodanaCoverageLoadingListener, File file2, String string, Exception exception, int n, Object object) {
        if ((n & 4) != 0) {
            exception = null;
        }
        qodanaCoverageLoadingListener.reportError(file2, string, exception);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/QodanaCoverageLoadingListener$Companion;", "", "<init>", "()V", "buildTooManyErrorMessage", "", "filePath", "intellij.qodana.coverage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String buildTooManyErrorMessage(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return "More errors than limit 10 were reported for file " + filePath + ". For all errors please see the idea.log file";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

