/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormats;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.PlatformIcons;
import java.util.Objects;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class CsvFormatsSettingsUI
extends CsvFormatsUI {
    public CsvFormatsSettingsUI(@NotNull Disposable parent) {
        if (parent == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(0);
        }
        this(true, parent, CsvFormatUISettings.DEFAULT);
    }

    public CsvFormatsSettingsUI(boolean allowNameEditing, @NotNull Disposable parent, @NotNull CsvFormatUISettings settings) {
        if (parent == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(2);
        }
        super(allowNameEditing, settings);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @Override
    @NotNull
    protected ToolbarDecorator createFormatListDecorator() {
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.getFormatsListComponent().getComponent()).setToolbarPosition(ActionToolbarPosition.TOP).setAddAction(button -> this.addNewAndEditName((CsvFormat)CsvFormats.TSV_FORMAT.getValue())).setEditAction(button -> this.editName(this.getNotNullSelectedFormat())).setEditActionUpdater(e -> this.getFormatsListComponent().getSelected() != null).addExtraAction((AnAction)new CopyFormatAction()).setAddActionName(DataGridBundle.message((String)"csv.format.settings.add", (Object[])new Object[0])).setRemoveActionName(DataGridBundle.message((String)"csv.format.settings.remove", (Object[])new Object[0])).setButtonComparator(new String[]{DataGridBundle.message((String)"csv.format.settings.add", (Object[])new Object[0]), DataGridBundle.message((String)"csv.format.settings.remove", (Object[])new Object[0]), DataGridBundle.message((String)"csv.format.settings.copy", (Object[])new Object[0])});
        if (toolbarDecorator == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(3);
        }
        return toolbarDecorator;
    }

    @NotNull
    private CsvFormat getNotNullSelectedFormat() {
        CsvFormat csvFormat = Objects.requireNonNull(this.getFormatsListComponent().getSelected());
        if (csvFormat == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(4);
        }
        return csvFormat;
    }

    private void addNewAndEditName(@NotNull CsvFormat templateFormat) {
        if (templateFormat == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(5);
        }
        this.editName(this.getFormatsListComponent().newFormat(templateFormat));
    }

    private void editName(@NotNull CsvFormat format) {
        if (format == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(6);
        }
        this.getFormatsListComponent().editFormatName(format, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/ui/CsvFormatsSettingsUI";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFormat";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsSettingsUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormatListDecorator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullSelectedFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addNewAndEditName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private class CopyFormatAction
    extends DumbAwareAction {
        CopyFormatAction() {
            super(DataGridBundle.message((String)"csv.format.settings.copy", (Object[])new Object[0]), null, PlatformIcons.COPY_ICON);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("EditorDuplicate"));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CopyFormatAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyFormatAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(CsvFormatsSettingsUI.this.getSelectedFormat() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyFormatAction.$$$reportNull$$$0(2);
            }
            CsvFormatsSettingsUI.this.addNewAndEditName(CsvFormatsSettingsUI.this.getNotNullSelectedFormat());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/csv/ui/CsvFormatsSettingsUI$CopyFormatAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsSettingsUI$CopyFormatAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

