/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.highlighting;

import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import com.jetbrains.python.parsing.console.PyConsoleHighlightingLexer;
import com.jetbrains.python.psi.LanguageLevel;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySyntaxHighlighterFactoryBase
extends SyntaxHighlighterFactory {
    private final Map<LanguageLevel, PyHighlighter> myMap = FactoryMap.create(key -> new PyHighlighter((LanguageLevel)((Object)key)));
    private final Map<LanguageLevel, PyHighlighter> myConsoleMap = FactoryMap.create(key -> new PyHighlighter((LanguageLevel)((Object)key)){

        @Override
        protected PythonHighlightingLexer createHighlightingLexer(LanguageLevel languageLevel) {
            return new PyConsoleHighlightingLexer(languageLevel);
        }
    });

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        LanguageLevel level = this.getLanguageLevel(project, virtualFile);
        if (this.useConsoleLexer(project, virtualFile)) {
            SyntaxHighlighter syntaxHighlighter = (SyntaxHighlighter)this.myConsoleMap.get((Object)level);
            if (syntaxHighlighter == null) {
                PySyntaxHighlighterFactoryBase.$$$reportNull$$$0(0);
            }
            return syntaxHighlighter;
        }
        SyntaxHighlighter syntaxHighlighter = this.getSyntaxHighlighterForLanguageLevel(level);
        if (syntaxHighlighter == null) {
            PySyntaxHighlighterFactoryBase.$$$reportNull$$$0(1);
        }
        return syntaxHighlighter;
    }

    @NotNull
    public SyntaxHighlighter getConsoleSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        LanguageLevel level = this.getLanguageLevel(project, virtualFile);
        SyntaxHighlighter syntaxHighlighter = (SyntaxHighlighter)this.myConsoleMap.get((Object)level);
        if (syntaxHighlighter == null) {
            PySyntaxHighlighterFactoryBase.$$$reportNull$$$0(2);
        }
        return syntaxHighlighter;
    }

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighterForLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            PySyntaxHighlighterFactoryBase.$$$reportNull$$$0(3);
        }
        SyntaxHighlighter syntaxHighlighter = (SyntaxHighlighter)this.myMap.get((Object)level);
        if (syntaxHighlighter == null) {
            PySyntaxHighlighterFactoryBase.$$$reportNull$$$0(4);
        }
        return syntaxHighlighter;
    }

    protected LanguageLevel getLanguageLevel(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        return LanguageLevel.getDefault();
    }

    protected boolean useConsoleLexer(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/highlighting/PySyntaxHighlighterFactoryBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntaxHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleSyntaxHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/highlighting/PySyntaxHighlighterFactoryBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntaxHighlighterForLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSyntaxHighlighterForLanguageLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

