/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.carets;

import com.intellij.cwm.plugin.common.carets.RemoteCaret;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.ui.scale.JBUIScale;
import com.jetbrains.rd.ide.editor.UtilKt;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/cwm/plugin/common/carets/RemoteCaretRenderingUtil;", "", "<init>", "()V", "calculatePinRectangle", "Ljava/awt/geom/Rectangle2D$Double;", "caret", "Lcom/intellij/cwm/plugin/common/carets/RemoteCaret;", "scale", "", "calculateCaretRectangle", "caretRectangle", "getPinSize", "caretWidth", "intellij.cwm.plugin.common"})
public final class RemoteCaretRenderingUtil {
    @NotNull
    public static final RemoteCaretRenderingUtil INSTANCE = new RemoteCaretRenderingUtil();

    private RemoteCaretRenderingUtil() {
    }

    @NotNull
    public final Rectangle2D.Double calculatePinRectangle(@NotNull RemoteCaret caret, double scale) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Rectangle2D.Double caretRectangle = this.calculateCaretRectangle(caret, scale);
        return this.calculatePinRectangle(caretRectangle);
    }

    @NotNull
    public final Rectangle2D.Double calculateCaretRectangle(@NotNull RemoteCaret caret, double scale) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        boolean bl2 = bl = scale > 0.0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Editor editor = caret.getEditor();
        boolean isRtl = false;
        VisualPosition visualPosition = UtilKt.docOffsetAndVirtualToVisualPosition((Editor)editor, (int)caret.getOffset(), (int)caret.getData().getCaretPosVirtualDelta(), (boolean)caret.getData().getCaretLogPosLeansForward());
        VisualPosition visualPosition2 = visualPosition.leanRight(isRtl ^ visualPosition.leansRight);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition2, (String)"leanRight(...)");
        visualPosition = visualPosition2;
        Point2D point2D = editor.visualPositionToPoint2D(visualPosition);
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"visualPositionToPoint2D(...)");
        Point2D caretPoint = point2D;
        int width = CaretVisualAttributes.getDefault().getWidth(editor.getSettings().getLineCursorWidth());
        double caretWidth = JBUIScale.scale((int)width);
        double caretShift = caretWidth <= 1.0 ? 0.0 : 1.0 / scale;
        double caretHeight = editor.getLineHeight();
        double x = Math.max(caretPoint.getX() - caretShift, this.getPinSize(caretWidth) / (double)2);
        return new Rectangle2D.Double(x, caretPoint.getY(), caretWidth, caretHeight);
    }

    @NotNull
    public final Rectangle2D.Double calculatePinRectangle(@NotNull Rectangle2D.Double caretRectangle) {
        Intrinsics.checkNotNullParameter((Object)caretRectangle, (String)"caretRectangle");
        double pinSize = this.getPinSize(caretRectangle.width);
        return new Rectangle2D.Double(caretRectangle.getCenterX() - pinSize / (double)2, caretRectangle.y, pinSize, pinSize);
    }

    private final double getPinSize(double caretWidth) {
        return caretWidth * (double)3;
    }
}

