/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVersionSpecialty;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitIndexUtil {
    private static final Logger LOG = Logger.getInstance(GitIndexUtil.class);
    private static final String EXECUTABLE_MODE = "100755";
    private static final String DEFAULT_MODE = "100644";

    @Nullable
    public static StagedFile listStaged(@NotNull GitRepository repository2, @NotNull FilePath filePath) throws VcsException {
        List<StagedFile> result2;
        if (repository2 == null) {
            GitIndexUtil.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(1);
        }
        if ((result2 = GitIndexUtil.listStaged(repository2, Collections.singleton(filePath))).size() != 1) {
            return null;
        }
        return result2.get(0);
    }

    @NotNull
    public static List<StagedFile> listStaged(@NotNull GitRepository repository2, @NotNull Collection<? extends FilePath> filePaths) throws VcsException {
        if (repository2 == null) {
            GitIndexUtil.$$$reportNull$$$0(2);
        }
        if (filePaths == null) {
            GitIndexUtil.$$$reportNull$$$0(3);
        }
        Project project = repository2.getProject();
        VirtualFile root = repository2.getRoot();
        return GitIndexUtil.listStaged(project, root, filePaths);
    }

    @NotNull
    public static List<StagedFile> listStaged(@NotNull Project project, final @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> filePaths) throws VcsException {
        if (project == null) {
            GitIndexUtil.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitIndexUtil.$$$reportNull$$$0(5);
        }
        if (filePaths == null) {
            GitIndexUtil.$$$reportNull$$$0(6);
        }
        final ArrayList<StagedFile> result2 = new ArrayList<StagedFile>();
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LS_FILES);
        h.addParameters("-s");
        h.endOptions();
        h.addRelativePaths(filePaths);
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                ContainerUtil.addIfNotNull((Collection)result2, (Object)GitIndexUtil.parseListFilesStagedRecord(root, line));
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        ArrayList<StagedFile> arrayList = result2;
        if (arrayList == null) {
            GitIndexUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public static StagedFile listTree(@NotNull GitRepository repository2, @NotNull FilePath filePath, @NotNull VcsRevisionNumber revision) throws VcsException {
        List<StagedFileOrDirectory> result2;
        if (repository2 == null) {
            GitIndexUtil.$$$reportNull$$$0(8);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(9);
        }
        if (revision == null) {
            GitIndexUtil.$$$reportNull$$$0(10);
        }
        if ((result2 = GitIndexUtil.listTree(repository2, Collections.singleton(filePath), revision)).size() != 1 || !(result2.get(0) instanceof StagedFile)) {
            return null;
        }
        return (StagedFile)result2.get(0);
    }

    @NotNull
    public static List<StagedFileOrDirectory> listTree(@NotNull GitRepository repository2, @NotNull Collection<? extends FilePath> filePaths, @NotNull VcsRevisionNumber revision) throws VcsException {
        if (repository2 == null) {
            GitIndexUtil.$$$reportNull$$$0(11);
        }
        if (filePaths == null) {
            GitIndexUtil.$$$reportNull$$$0(12);
        }
        if (revision == null) {
            GitIndexUtil.$$$reportNull$$$0(13);
        }
        ArrayList<StagedFileOrDirectory> result2 = new ArrayList<StagedFileOrDirectory>();
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)repository2.getRoot(), filePaths)) {
            result2.addAll(GitIndexUtil.listTreeForRawPaths(repository2, paths, revision));
        }
        ArrayList<StagedFileOrDirectory> arrayList = result2;
        if (arrayList == null) {
            GitIndexUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static List<StagedFileOrDirectory> listTreeForRawPaths(@NotNull GitRepository repository2, @NotNull List<String> filePaths, @NotNull VcsRevisionNumber revision) throws VcsException {
        if (repository2 == null) {
            GitIndexUtil.$$$reportNull$$$0(15);
        }
        if (filePaths == null) {
            GitIndexUtil.$$$reportNull$$$0(16);
        }
        if (revision == null) {
            GitIndexUtil.$$$reportNull$$$0(17);
        }
        return GitIndexUtil.listTreeForRawPaths(repository2.getProject(), repository2.getRoot(), filePaths, revision);
    }

    @NotNull
    public static List<StagedFileOrDirectory> listTreeForRawPaths(@Nullable Project project, final @NotNull VirtualFile repositoryRoot, @NotNull List<String> filePaths, @NotNull VcsRevisionNumber revision) throws VcsException {
        if (repositoryRoot == null) {
            GitIndexUtil.$$$reportNull$$$0(18);
        }
        if (filePaths == null) {
            GitIndexUtil.$$$reportNull$$$0(19);
        }
        if (revision == null) {
            GitIndexUtil.$$$reportNull$$$0(20);
        }
        final ArrayList<StagedFileOrDirectory> result2 = new ArrayList<StagedFileOrDirectory>();
        GitLineHandler h = new GitLineHandler(project, repositoryRoot, GitCommand.LS_TREE);
        h.addParameters(revision.asString());
        h.endOptions();
        h.addParameters(filePaths);
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                ContainerUtil.addIfNotNull((Collection)result2, (Object)GitIndexUtil.parseListTreeRecord(repositoryRoot, line));
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
        ArrayList<StagedFileOrDirectory> arrayList = result2;
        if (arrayList == null) {
            GitIndexUtil.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Nullable
    private static StagedFile parseListFilesStagedRecord(@NotNull VirtualFile root, @NotNull String line) {
        if (root == null) {
            GitIndexUtil.$$$reportNull$$$0(22);
        }
        if (line == null) {
            GitIndexUtil.$$$reportNull$$$0(23);
        }
        try {
            StringScanner s = new StringScanner(line);
            String permissions = s.spaceToken();
            String hash = s.spaceToken();
            String stage = s.tabToken();
            String filePath = s.line();
            if (!"0".equals(stage)) {
                return null;
            }
            FilePath path = VcsUtil.getFilePath((VirtualFile)root, (String)GitUtil.unescapePath(filePath));
            boolean executable = EXECUTABLE_MODE.equals(permissions);
            return new StagedFile(path, hash, executable);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static StagedFileOrDirectory parseListTreeRecord(@NotNull VirtualFile root, @NotNull String line) {
        if (root == null) {
            GitIndexUtil.$$$reportNull$$$0(24);
        }
        if (line == null) {
            GitIndexUtil.$$$reportNull$$$0(25);
        }
        try {
            StringScanner s = new StringScanner(line);
            String permissions = s.spaceToken();
            String type = s.spaceToken();
            String hash = s.tabToken();
            String filePath = GitUtil.unescapePath(s.line());
            if ("tree".equals(type)) {
                return new StagedDirectory(VcsUtil.getFilePath((VirtualFile)root, (String)filePath, (boolean)true));
            }
            if ("commit".equals(type)) {
                return new StagedSubrepo(VcsUtil.getFilePath((VirtualFile)root, (String)filePath, (boolean)true), hash);
            }
            if (!"blob".equals(type)) {
                return null;
            }
            boolean executable = EXECUTABLE_MODE.equals(permissions);
            return new StagedFile(VcsUtil.getFilePath((VirtualFile)root, (String)filePath), hash, executable);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static Hash loadStagedSubmoduleHash(@NotNull GitRepository submodule, @NotNull GitRepository parentRepo) throws VcsException {
        if (submodule == null) {
            GitIndexUtil.$$$reportNull$$$0(26);
        }
        if (parentRepo == null) {
            GitIndexUtil.$$$reportNull$$$0(27);
        }
        GitLineHandler h = new GitLineHandler(parentRepo.getProject(), parentRepo.getRoot(), GitCommand.SUBMODULE);
        h.addParameters("status", "--cached");
        h.addRelativeFiles(Collections.singletonList(submodule.getRoot()));
        String out = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        StringScanner s = new StringScanner(out);
        s.skipChars(1);
        String hash = s.spaceToken();
        Hash hash2 = HashImpl.build((String)hash);
        if (hash2 == null) {
            GitIndexUtil.$$$reportNull$$$0(28);
        }
        return hash2;
    }

    @Nullable
    public static Hash loadSubmoduleHashAt(@NotNull GitRepository submodule, @NotNull GitRepository parentRepo, @NotNull VcsRevisionNumber revisionNumber) throws VcsException {
        FilePath filePath;
        List<StagedFileOrDirectory> lsTree;
        if (submodule == null) {
            GitIndexUtil.$$$reportNull$$$0(29);
        }
        if (parentRepo == null) {
            GitIndexUtil.$$$reportNull$$$0(30);
        }
        if (revisionNumber == null) {
            GitIndexUtil.$$$reportNull$$$0(31);
        }
        if ((lsTree = GitIndexUtil.listTree(parentRepo, Collections.singletonList(filePath = VcsUtil.getFilePath((VirtualFile)submodule.getRoot())), revisionNumber)).size() != 1) {
            LOG.warn(String.format("Unexpected output of ls-tree command for submodule [%s] at [%s]: %s", filePath, revisionNumber, lsTree));
            return null;
        }
        StagedSubrepo tree = (StagedSubrepo)ObjectUtils.tryCast((Object)lsTree.get(0), StagedSubrepo.class);
        if (tree == null) {
            LOG.warn(String.format("Unexpected type of ls-tree for submodule [%s] at [%s]: %s", filePath, revisionNumber, tree));
            return null;
        }
        if (!filePath.equals(tree.getPath())) {
            LOG.warn(String.format("Submodule path [%s] doesn't match the ls-tree output path [%s]", tree.getPath(), filePath));
            return null;
        }
        return HashImpl.build((String)tree.getBlobHash());
    }

    @NotNull
    public static Hash write(@NotNull GitRepository repository2, @NotNull FilePath filePath, byte @NotNull [] bytes, boolean executable) throws VcsException {
        if (repository2 == null) {
            GitIndexUtil.$$$reportNull$$$0(32);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(33);
        }
        if (bytes == null) {
            GitIndexUtil.$$$reportNull$$$0(34);
        }
        return GitIndexUtil.write(repository2, filePath, new ByteArrayInputStream(bytes), executable);
    }

    @NotNull
    public static Hash write(@NotNull GitRepository repository2, @NotNull FilePath filePath, @NotNull InputStream content, boolean executable) throws VcsException {
        if (repository2 == null) {
            GitIndexUtil.$$$reportNull$$$0(35);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(36);
        }
        if (content == null) {
            GitIndexUtil.$$$reportNull$$$0(37);
        }
        return GitIndexUtil.write(repository2.getProject(), repository2.getRoot(), filePath, content, executable);
    }

    @NotNull
    public static Hash write(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull InputStream content, boolean executable) throws VcsException {
        if (project == null) {
            GitIndexUtil.$$$reportNull$$$0(38);
        }
        if (root == null) {
            GitIndexUtil.$$$reportNull$$$0(39);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(40);
        }
        if (content == null) {
            GitIndexUtil.$$$reportNull$$$0(41);
        }
        return GitIndexUtil.write(project, root, filePath, content, executable, false);
    }

    @NotNull
    public static Hash write(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull InputStream content, boolean executable, boolean addNewFiles) throws VcsException {
        if (project == null) {
            GitIndexUtil.$$$reportNull$$$0(42);
        }
        if (root == null) {
            GitIndexUtil.$$$reportNull$$$0(43);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(44);
        }
        if (content == null) {
            GitIndexUtil.$$$reportNull$$$0(45);
        }
        Hash hash = GitIndexUtil.hashObject(project, root, filePath, content);
        GitIndexUtil.updateIndex(project, root, filePath, hash, executable, addNewFiles);
        Hash hash2 = hash;
        if (hash2 == null) {
            GitIndexUtil.$$$reportNull$$$0(46);
        }
        return hash2;
    }

    @NotNull
    private static Hash hashObject(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull InputStream content) throws VcsException {
        if (project == null) {
            GitIndexUtil.$$$reportNull$$$0(47);
        }
        if (root == null) {
            GitIndexUtil.$$$reportNull$$$0(48);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(49);
        }
        if (content == null) {
            GitIndexUtil.$$$reportNull$$$0(50);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.HASH_OBJECT);
        h.setSilent(true);
        h.addParameters("-w", "--stdin");
        h.addParameters("--path");
        h.addRelativePaths(filePath);
        h.setInputProcessor(GitHandlerInputProcessorUtil.redirectStream(content));
        h.endOptions();
        String output2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Hash hash = HashImpl.build((String)output2.trim());
        if (hash == null) {
            GitIndexUtil.$$$reportNull$$$0(51);
        }
        return hash;
    }

    public static void updateIndex(@NotNull GitRepository repository2, @NotNull FilePath filePath, @NotNull Hash blobHash, boolean isExecutable) throws VcsException {
        if (repository2 == null) {
            GitIndexUtil.$$$reportNull$$$0(52);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(53);
        }
        if (blobHash == null) {
            GitIndexUtil.$$$reportNull$$$0(54);
        }
        GitIndexUtil.updateIndex(repository2.getProject(), repository2.getRoot(), filePath, blobHash, isExecutable, false);
    }

    public static void updateIndex(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull Hash blobHash, boolean isExecutable, boolean addNewFiles) throws VcsException {
        if (project == null) {
            GitIndexUtil.$$$reportNull$$$0(55);
        }
        if (root == null) {
            GitIndexUtil.$$$reportNull$$$0(56);
        }
        if (filePath == null) {
            GitIndexUtil.$$$reportNull$$$0(57);
        }
        if (blobHash == null) {
            GitIndexUtil.$$$reportNull$$$0(58);
        }
        String mode = isExecutable ? EXECUTABLE_MODE : DEFAULT_MODE;
        String path = VcsFileUtil.relativePath((VirtualFile)root, (FilePath)filePath);
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.UPDATE_INDEX);
        if (addNewFiles) {
            h.addParameters("--add");
        }
        if (GitVersionSpecialty.CACHEINFO_SUPPORTS_SINGLE_PARAMETER_FORM.existsIn(project)) {
            h.addParameters("--cacheinfo", mode + "," + blobHash.asString() + "," + path);
        } else {
            h.addParameters("--cacheinfo", mode, blobHash.asString(), path);
        }
        h.endOptions();
        Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
    }

    public static byte @NotNull [] read(@NotNull GitRepository repository2, @NotNull String blobHash) throws VcsException {
        if (repository2 == null) {
            GitIndexUtil.$$$reportNull$$$0(59);
        }
        if (blobHash == null) {
            GitIndexUtil.$$$reportNull$$$0(60);
        }
        Project project = repository2.getProject();
        VirtualFile root = repository2.getRoot();
        GitBinaryHandler h = new GitBinaryHandler(project, root, GitCommand.SHOW);
        h.setSilent(true);
        h.addParameters(blobHash);
        h.endOptions();
        byte[] byArray = h.run();
        if (byArray == null) {
            GitIndexUtil.$$$reportNull$$$0(61);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 14, 21, 28, 46, 51, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: 
            case 9: 
            case 33: 
            case 36: 
            case 40: 
            case 44: 
            case 49: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 4: 
            case 38: 
            case 42: 
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 22: 
            case 24: 
            case 39: 
            case 43: 
            case 48: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 14: 
            case 21: 
            case 28: 
            case 46: 
            case 51: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/index/GitIndexUtil";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryRoot";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "submodule";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRepo";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 37: 
            case 41: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 54: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blobHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/index/GitIndexUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "listStaged";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "listTree";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "listTreeForRawPaths";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "loadStagedSubmoduleHash";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "hashObject";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listStaged";
                break;
            }
            case 7: 
            case 14: 
            case 21: 
            case 28: 
            case 46: 
            case 51: 
            case 61: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "listTree";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "listTreeForRawPaths";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseListFilesStagedRecord";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseListTreeRecord";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadStagedSubmoduleHash";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadSubmoduleHashAt";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "hashObject";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 14, 21, 28, 46, 51, 61 -> new IllegalStateException(string);
        };
    }

    public static class StagedFile
    extends StagedFileOrDirectory {
        @NotNull
        private final String myBlobHash;
        private final boolean myExecutable;

        public StagedFile(@NotNull FilePath path, @NotNull String blobHash, boolean executable) {
            if (path == null) {
                StagedFile.$$$reportNull$$$0(0);
            }
            if (blobHash == null) {
                StagedFile.$$$reportNull$$$0(1);
            }
            super(path);
            this.myBlobHash = blobHash;
            this.myExecutable = executable;
        }

        @NotNull
        public String getBlobHash() {
            String string = this.myBlobHash;
            if (string == null) {
                StagedFile.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isExecutable() {
            return this.myExecutable;
        }

        @Override
        @NonNls
        public String toString() {
            return "StagedFile[" + String.valueOf(this.myPath) + "] at [" + this.myBlobHash + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blobHash";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/index/GitIndexUtil$StagedFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/index/GitIndexUtil$StagedFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBlobHash";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class StagedDirectory
    extends StagedFileOrDirectory {
        public StagedDirectory(@NotNull FilePath path) {
            if (path == null) {
                StagedDirectory.$$$reportNull$$$0(0);
            }
            super(path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/index/GitIndexUtil$StagedDirectory", "<init>"));
        }
    }

    public static class StagedSubrepo
    extends StagedFileOrDirectory {
        @NotNull
        private final String myBlobHash;

        public StagedSubrepo(@NotNull FilePath path, @NotNull String blobHash) {
            if (path == null) {
                StagedSubrepo.$$$reportNull$$$0(0);
            }
            if (blobHash == null) {
                StagedSubrepo.$$$reportNull$$$0(1);
            }
            super(path);
            this.myBlobHash = blobHash;
        }

        @NotNull
        public String getBlobHash() {
            String string = this.myBlobHash;
            if (string == null) {
                StagedSubrepo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NonNls
        public String toString() {
            return "StagedSubRepo[" + String.valueOf(this.myPath) + "] at [" + this.myBlobHash + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blobHash";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/index/GitIndexUtil$StagedSubrepo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/index/GitIndexUtil$StagedSubrepo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBlobHash";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class StagedFileOrDirectory {
        @NotNull
        protected final FilePath myPath;

        public StagedFileOrDirectory(@NotNull FilePath path) {
            if (path == null) {
                StagedFileOrDirectory.$$$reportNull$$$0(0);
            }
            this.myPath = path;
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = this.myPath;
            if (filePath == null) {
                StagedFileOrDirectory.$$$reportNull$$$0(1);
            }
            return filePath;
        }

        @NonNls
        public String toString() {
            return "StagedFileOrDirectory[" + String.valueOf(this.myPath) + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/index/GitIndexUtil$StagedFileOrDirectory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/index/GitIndexUtil$StagedFileOrDirectory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

