/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsBaseRevisionAdviser;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcs.log.ui.actions.ShowCommitInLogAction;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitObjectType;
import git4idea.history.GitDiffFromHistoryHandler;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryUtils;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitHistoryProvider
implements VcsHistoryProviderEx,
VcsCacheableHistorySessionFactory<Boolean, VcsAbstractHistorySession>,
VcsBaseRevisionAdviser {
    private static final Logger LOG = Logger.getInstance((String)GitHistoryProvider.class.getName());
    @NotNull
    private final Project myProject;

    public GitHistoryProvider(@NotNull Project project) {
        if (project == null) {
            GitHistoryProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])ColumnInfo.EMPTY_ARRAY);
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return new AnAction[]{ShowAllAffectedGenericAction.getInstance(), ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction"), new ShowCommitInLogAction()};
    }

    public boolean isDateOmittable() {
        return false;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    public VcsAbstractHistorySession createFromCachedData(Boolean aBoolean, @NotNull List<? extends VcsFileRevision> revisions, @NotNull FilePath filePath, VcsRevisionNumber currentRevision) {
        if (revisions == null) {
            GitHistoryProvider.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            GitHistoryProvider.$$$reportNull$$$0(2);
        }
        return this.createSession(filePath, revisions, currentRevision);
    }

    @NotNull
    public VcsAbstractHistorySession createSessionFor(FilePath filePath) throws VcsException {
        List<VcsFileRevision> revisions;
        VcsAbstractHistorySession vcsAbstractHistorySession = this.createSession(filePath, revisions, (revisions = GitFileHistory.collectHistory(this.myProject, filePath, new String[0])).isEmpty() ? null : ((VcsFileRevision)ContainerUtil.getFirstItem(revisions)).getRevisionNumber());
        if (vcsAbstractHistorySession == null) {
            GitHistoryProvider.$$$reportNull$$$0(3);
        }
        return vcsAbstractHistorySession;
    }

    private VcsAbstractHistorySession createSession(FilePath filePath, List<? extends VcsFileRevision> revisions, @Nullable VcsRevisionNumber number) {
        return new GitHistorySession(filePath, number, revisions);
    }

    @Nullable
    public VcsFileRevision getLastRevision(FilePath filePath) throws VcsException {
        List<VcsFileRevision> history = GitFileHistory.collectHistory(this.myProject, filePath, "--max-count=1");
        if (history.isEmpty()) {
            return null;
        }
        return history.get(0);
    }

    @Nullable
    public String getBaseVersionContent(@NotNull FilePath filePath, @NotNull String beforeVersionId) throws VcsException {
        String string;
        if (filePath == null) {
            GitHistoryProvider.$$$reportNull$$$0(4);
        }
        if (beforeVersionId == null) {
            GitHistoryProvider.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)beforeVersionId) || filePath.getVirtualFile() == null) {
            return null;
        }
        if (!GitUtil.isHashString(beforeVersionId, false)) {
            return null;
        }
        GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(filePath);
        if (repository2 == null) {
            return null;
        }
        GitObjectType objectType = Git.getInstance().getObjectTypeEnum(repository2, beforeVersionId);
        if (objectType == null) {
            string = null;
        } else {
            switch (objectType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case COMMIT: {
                    string = GitContentRevision.createRevision(filePath, (VcsRevisionNumber)new GitRevisionNumber(beforeVersionId), this.myProject).getContent();
                    break;
                }
                case BLOB: {
                    string = ContentRevisionCache.getAsString((byte[])GitIndexUtil.read(repository2, beforeVersionId), (FilePath)filePath, null);
                    break;
                }
                case TREE: {
                    string = null;
                }
            }
        }
        return string;
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) {
        this.reportAppendableHistory(path, null, partner);
    }

    public void reportAppendableHistory(@NotNull FilePath path, @Nullable VcsRevisionNumber startingRevision, @NotNull VcsAppendableHistorySessionPartner partner) {
        if (path == null) {
            GitHistoryProvider.$$$reportNull$$$0(6);
        }
        if (partner == null) {
            GitHistoryProvider.$$$reportNull$$$0(7);
        }
        VcsAbstractHistorySession emptySession = this.createSession(path, Collections.emptyList(), null);
        partner.reportCreatedEmptySession(emptySession);
        String[] additionalArgs = GitHistoryProvider.getHistoryLimitArgs(this.myProject);
        GitFileHistory.loadHistory(this.myProject, path, startingRevision, fileRevision -> partner.acceptRevision((VcsFileRevision)fileRevision), exception -> partner.reportException(exception), rename -> {}, additionalArgs);
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return new GitDiffFromHistoryHandler(this.myProject);
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        GitRepositoryManager manager;
        GitRepository repository2;
        if (file == null) {
            GitHistoryProvider.$$$reportNull$$$0(8);
        }
        return (repository2 = (GitRepository)(manager = GitUtil.getRepositoryManager(this.myProject)).getRepositoryForFileQuick(file)) != null && !repository2.isFresh();
    }

    static String @NotNull [] getHistoryLimitArgs(@NotNull Project project) {
        String[] stringArray;
        if (project == null) {
            GitHistoryProvider.$$$reportNull$$$0(9);
        }
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)project);
        if (vcsConfiguration.LIMIT_HISTORY) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--max-count=" + vcsConfiguration.MAXIMUM_HISTORY_ROWS;
        } else {
            stringArray = ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        if (stringArray == null) {
            GitHistoryProvider.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitHistoryProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeVersionId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitHistoryProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionFor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryLimitArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFromCachedData";
                break;
            }
            case 3: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBaseVersionContent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reportAppendableHistory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canShowHistoryFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHistoryLimitArgs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 10 -> new IllegalStateException(string);
        };
    }

    final class GitHistorySession
    extends VcsAbstractHistorySession {
        @NotNull
        private final FilePath myFilePath;

        GitHistorySession(@Nullable FilePath filePath, @NotNull VcsRevisionNumber number, List<? extends VcsFileRevision> revisions) {
            if (filePath == null) {
                GitHistorySession.$$$reportNull$$$0(0);
            }
            if (revisions == null) {
                GitHistorySession.$$$reportNull$$$0(1);
            }
            super(revisions, number);
            this.myFilePath = filePath;
        }

        @Nullable
        protected VcsRevisionNumber calcCurrentRevisionNumber() {
            try {
                return GitHistoryUtils.getCurrentRevision(GitHistoryProvider.this.myProject, this.myFilePath, "HEAD");
            }
            catch (VcsException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to retrieve the current revision number", (Throwable)e);
                }
                return null;
            }
        }

        public VcsHistorySession copy() {
            return GitHistoryProvider.this.createSession(this.myFilePath, this.getRevisionList(), this.getCurrentRevisionNumber());
        }

        @NotNull
        FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                GitHistorySession.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revisions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/history/GitHistoryProvider$GitHistorySession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/history/GitHistoryProvider$GitHistorySession";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

