/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.PropertyResourceBundle;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class XMLCatalogManager {
    private static final Logger LOG = Logger.getInstance(XMLCatalogManager.class);
    private static final Field ourResources;
    private static final Field ourPropertyFileUri;
    private final CatalogManager myManager;

    public XMLCatalogManager(@NotNull String propertiesFilePath) {
        if (propertiesFilePath == null) {
            XMLCatalogManager.$$$reportNull$$$0(0);
        }
        this.myManager = new CatalogManager();
        File file = new File(propertiesFilePath);
        try {
            String s = FileUtil.loadFile((File)file);
            PropertyResourceBundle bundle = new PropertyResourceBundle(new StringReader(s));
            ourResources.set(this.myManager, bundle);
            ourPropertyFileUri.set(this.myManager, file.toURI().toURL());
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Nullable
    public String resolve(String uri) {
        try {
            Catalog catalog = this.myManager.getCatalog();
            if (catalog == null) {
                return null;
            }
            String byUri = catalog.resolveURI(uri);
            if (byUri != null) {
                return byUri;
            }
            String resolved = catalog.resolveSystem(uri);
            return resolved == null ? catalog.resolvePublic(uri, null) : resolved;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @TestOnly
    public CatalogManager getManager() {
        return this.myManager;
    }

    static {
        try {
            ourResources = CatalogManager.class.getDeclaredField("resources");
            ourResources.setAccessible(true);
            ourPropertyFileUri = CatalogManager.class.getDeclaredField("propertyFileURI");
            ourPropertyFileUri.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFilePath", "com/intellij/javaee/XMLCatalogManager", "<init>"));
    }
}

