/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.singleFile;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterChangeListener;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterEvent;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileSaveChangeListener;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterChangeListener;", "document", "Lcom/intellij/openapi/editor/impl/DocumentImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/DocumentImpl;)V", "getDocument", "()Lcom/intellij/openapi/editor/impl/DocumentImpl;", "onEvent", "", "event", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterEvent;", "Companion", "intellij.jupyter.core"})
public final class JupyterFileSaveChangeListener
implements JupyterChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocumentImpl document;

    public JupyterFileSaveChangeListener(@NotNull DocumentImpl document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
    }

    @NotNull
    public final DocumentImpl getDocument() {
        return this.document;
    }

    @Override
    public void onEvent(@NotNull JupyterEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.document.isInEventsHandling()) {
            return;
        }
        this.document.setModificationStamp(LocalTimeCounter.currentTime());
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile((Document)this.document);
        if (virtualFile2 != null && virtualFile2.getDetectedLineSeparator() == null) {
            virtualFile2.setDetectedLineSeparator("\n");
        }
        ActionsKt.runReadAction(() -> JupyterFileSaveChangeListener.onEvent$lambda$0(this));
    }

    private static final Unit onEvent$lambda$0(JupyterFileSaveChangeListener this$0) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNull((Object)fileDocumentManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl");
        ((FileDocumentManagerImpl)fileDocumentManager).markDocumentUnsaved((Document)this$0.document, true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileSaveChangeListener$Companion;", "", "<init>", "()V", "setup", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void setup(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            BackedNotebookVirtualFile file = JupyterEditorExtensionsKt.getNotebookFile(editor);
            Document document = editor.getDocument();
            Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
            DocumentImpl document2 = (DocumentImpl)document;
            JupyterNotebook notebook = file.getNotebook();
            notebook.getListeners().getChangeListeners().addListener((EventListener)new JupyterFileSaveChangeListener(document2), ((EditorImpl)editor).getDisposable());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

