/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) << 0u) => u64vec2(10ul, 12ul)
 * (u64vec2(10ul, 12ul) << 1u) => u64vec2(20ul, 24ul)
 * (u64vec2(10ul, 12ul) << 2u) => u64vec2(40ul, 48ul)
 * (u64vec2(10ul, 12ul) << 5u) => u64vec2(320ul, 384ul)
 * (u64vec2(10ul, 12ul) << 25u) => u64vec2(335544320ul, 402653184ul)
 * (u64vec2(10ul, 12ul) << 31u) => u64vec2(21474836480ul, 25769803776ul)
 * (u64vec2(42ul, 48ul) << 0u) => u64vec2(42ul, 48ul)
 * (u64vec2(42ul, 48ul) << 1u) => u64vec2(84ul, 96ul)
 * (u64vec2(42ul, 48ul) << 2u) => u64vec2(168ul, 192ul)
 * (u64vec2(42ul, 48ul) << 5u) => u64vec2(1344ul, 1536ul)
 * (u64vec2(42ul, 48ul) << 25u) => u64vec2(1409286144ul, 1610612736ul)
 * (u64vec2(42ul, 48ul) << 31u) => u64vec2(90194313216ul, 103079215104ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) << 0u), u64vec2(10ul, 12ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(10ul, 12ul) << 1u), u64vec2(20ul, 24ul))) ? 1 : -1] array1;
  float[all(equal((u64vec2(10ul, 12ul) << 2u), u64vec2(40ul, 48ul))) ? 1 : -1] array2;
  float[all(equal((u64vec2(10ul, 12ul) << 5u), u64vec2(320ul, 384ul))) ? 1 : -1] array3;
  float[all(equal((u64vec2(10ul, 12ul) << 25u), u64vec2(335544320ul, 402653184ul))) ? 1 : -1] array4;
  float[all(equal((u64vec2(10ul, 12ul) << 31u), u64vec2(21474836480ul, 25769803776ul))) ? 1 : -1] array5;
  float[all(equal((u64vec2(42ul, 48ul) << 0u), u64vec2(42ul, 48ul))) ? 1 : -1] array6;
  float[all(equal((u64vec2(42ul, 48ul) << 1u), u64vec2(84ul, 96ul))) ? 1 : -1] array7;
  float[all(equal((u64vec2(42ul, 48ul) << 2u), u64vec2(168ul, 192ul))) ? 1 : -1] array8;
  float[all(equal((u64vec2(42ul, 48ul) << 5u), u64vec2(1344ul, 1536ul))) ? 1 : -1] array9;
  float[all(equal((u64vec2(42ul, 48ul) << 25u), u64vec2(1409286144ul, 1610612736ul))) ? 1 : -1] array10;
  float[all(equal((u64vec2(42ul, 48ul) << 31u), u64vec2(90194313216ul, 103079215104ul))) ? 1 : -1] array11;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
