/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import net.wimpi.modbus.io.ModbusSerialTransaction;
import net.wimpi.modbus.io.ModbusTCPTransaction;
import net.wimpi.modbus.io.ModbusTransaction;
import net.wimpi.modbus.io.ModbusUDPTransaction;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadCoilsRequest;
import net.wimpi.modbus.msg.ReadCoilsResponse;
import net.wimpi.modbus.msg.ReadInputDiscretesRequest;
import net.wimpi.modbus.msg.ReadInputDiscretesResponse;
import net.wimpi.modbus.msg.ReadInputRegistersRequest;
import net.wimpi.modbus.msg.ReadInputRegistersResponse;
import net.wimpi.modbus.msg.ReadMultipleRegistersRequest;
import net.wimpi.modbus.msg.ReadMultipleRegistersResponse;
import net.wimpi.modbus.msg.WriteCoilRequest;
import net.wimpi.modbus.msg.WriteMultipleCoilsRequest;
import net.wimpi.modbus.msg.WriteMultipleRegistersRequest;
import net.wimpi.modbus.msg.WriteSingleRegisterRequest;
import net.wimpi.modbus.net.ModbusSlaveConnection;
import net.wimpi.modbus.net.SerialConnection;
import net.wimpi.modbus.net.TCPMasterConnection;
import net.wimpi.modbus.net.UDPMasterConnection;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleInputRegister;
import net.wimpi.modbus.util.BitVector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.transport.modbus.AsyncModbusReadResult;
import org.openhab.core.io.transport.modbus.BitArray;
import org.openhab.core.io.transport.modbus.ModbusReadCallback;
import org.openhab.core.io.transport.modbus.ModbusReadFunctionCode;
import org.openhab.core.io.transport.modbus.ModbusReadRequestBlueprint;
import org.openhab.core.io.transport.modbus.ModbusRegisterArray;
import org.openhab.core.io.transport.modbus.ModbusWriteCoilRequestBlueprint;
import org.openhab.core.io.transport.modbus.ModbusWriteRegisterRequestBlueprint;
import org.openhab.core.io.transport.modbus.ModbusWriteRequestBlueprint;
import org.openhab.core.io.transport.modbus.ModbusWriteRequestBlueprintVisitor;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSerialSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSlaveEndpointVisitor;
import org.openhab.core.io.transport.modbus.endpoint.ModbusTCPSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusUDPSlaveEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ModbusLibraryWrapper {
    private static Logger getLogger() {
        return LoggerFactory.getLogger(ModbusLibraryWrapper.class);
    }

    private static BitArray bitArrayFromBitVector(BitVector bitVector, int count) {
        boolean[] bits = new boolean[count];
        int i = 0;
        while (i < count) {
            bits[i] = bitVector.getBit(i);
            ++i;
        }
        return new BitArray(bits);
    }

    private static ModbusRegisterArray modbusRegisterArrayFromInputRegisters(InputRegister[] inputRegisters) {
        int[] registers = new int[inputRegisters.length];
        int i = 0;
        while (i < inputRegisters.length) {
            registers[i] = inputRegisters[i].getValue();
            ++i;
        }
        return new ModbusRegisterArray(registers);
    }

    public static ModbusRequest createRequest(final ModbusWriteRequestBlueprint message) {
        final AtomicReference request = new AtomicReference();
        final AtomicBoolean writeSingle = new AtomicBoolean(false);
        switch (message.getFunctionCode()) {
            case WRITE_COIL: {
                writeSingle.set(true);
            }
            case WRITE_MULTIPLE_COILS: {
                message.accept(new ModbusWriteRequestBlueprintVisitor(){

                    @Override
                    public void visit(ModbusWriteRegisterRequestBlueprint blueprint) {
                        throw new IllegalArgumentException();
                    }

                    @Override
                    public void visit(ModbusWriteCoilRequestBlueprint blueprint) {
                        BitArray coils = blueprint.getCoils();
                        if (coils.size() == 0) {
                            throw new IllegalArgumentException("Must provide at least one coil");
                        }
                        if (writeSingle.get()) {
                            if (coils.size() != 1) {
                                throw new IllegalArgumentException("Must provide single coil with WRITE_COIL");
                            }
                            request.set(new WriteCoilRequest(message.getReference(), coils.getBit(0)));
                        } else {
                            request.set(new WriteMultipleCoilsRequest(message.getReference(), ModbusLibraryWrapper.convertBits(coils)));
                        }
                    }
                });
                break;
            }
            case WRITE_SINGLE_REGISTER: {
                writeSingle.set(true);
            }
            case WRITE_MULTIPLE_REGISTERS: {
                message.accept(new ModbusWriteRequestBlueprintVisitor(){

                    @Override
                    public void visit(ModbusWriteRegisterRequestBlueprint blueprint) {
                        Register[] registers = ModbusLibraryWrapper.convertRegisters(blueprint.getRegisters());
                        if (registers.length == 0) {
                            throw new IllegalArgumentException("Must provide at least one register");
                        }
                        if (writeSingle.get()) {
                            if (blueprint.getRegisters().size() != 1) {
                                throw new IllegalArgumentException("Must provide single register with WRITE_SINGLE_REGISTER");
                            }
                            request.set(new WriteSingleRegisterRequest(message.getReference(), registers[0]));
                        } else {
                            request.set(new WriteMultipleRegistersRequest(message.getReference(), registers));
                        }
                    }

                    @Override
                    public void visit(ModbusWriteCoilRequestBlueprint blueprint) {
                        throw new IllegalArgumentException();
                    }
                });
                break;
            }
            default: {
                ModbusLibraryWrapper.getLogger().error("Unexpected function code {}", (Object)message.getFunctionCode());
                throw new IllegalStateException(String.format("Unexpected function code %s", new Object[]{message.getFunctionCode()}));
            }
        }
        ModbusRequest modbusRequest = (ModbusRequest)request.get();
        modbusRequest.setUnitID(message.getUnitID());
        modbusRequest.setProtocolID(message.getProtocolID());
        return modbusRequest;
    }

    /*
     * WARNING - void declaration
     */
    public static ModbusTransaction createTransactionForEndpoint(ModbusSlaveEndpoint endpoint, ModbusSlaveConnection connection) {
        ModbusTransaction transaction = endpoint.accept(new ModbusSlaveEndpointVisitor<ModbusTransaction>(){

            @Override
            public @NonNull ModbusTransaction visit(ModbusTCPSlaveEndpoint modbusIPSlavePoolingKey) {
                ModbusTCPTransaction transaction = new ModbusTCPTransaction();
                transaction.setReconnecting(false);
                return transaction;
            }

            @Override
            public @NonNull ModbusTransaction visit(ModbusSerialSlaveEndpoint modbusSerialSlavePoolingKey) {
                return new ModbusSerialTransaction();
            }

            @Override
            public @NonNull ModbusTransaction visit(ModbusUDPSlaveEndpoint modbusUDPSlavePoolingKey) {
                return new ModbusUDPTransaction();
            }
        });
        transaction.setRetries(0);
        transaction.setRetryDelayMillis(0L);
        ModbusTransaction modbusTransaction = transaction;
        if (modbusTransaction instanceof ModbusSerialTransaction) {
            void serialTransaction;
            ModbusSerialTransaction modbusSerialTransaction = (ModbusSerialTransaction)modbusTransaction;
            ModbusSerialTransaction cfr_ignored_0 = (ModbusSerialTransaction)modbusTransaction;
            serialTransaction.setSerialConnection((SerialConnection)connection);
        } else {
            ModbusTransaction modbusTransaction2 = transaction;
            if (modbusTransaction2 instanceof ModbusUDPTransaction) {
                void pTransaction;
                ModbusUDPTransaction modbusUDPTransaction = (ModbusUDPTransaction)modbusTransaction2;
                ModbusUDPTransaction cfr_ignored_1 = (ModbusUDPTransaction)modbusTransaction2;
                pTransaction.setTerminal(((UDPMasterConnection)connection).getTerminal());
            } else {
                ModbusTransaction modbusTransaction3 = transaction;
                if (modbusTransaction3 instanceof ModbusTCPTransaction) {
                    void pTransaction;
                    ModbusTCPTransaction modbusTCPTransaction = (ModbusTCPTransaction)modbusTransaction3;
                    ModbusTCPTransaction cfr_ignored_2 = (ModbusTCPTransaction)modbusTransaction3;
                    pTransaction.setConnection((TCPMasterConnection)connection);
                } else {
                    throw new IllegalStateException();
                }
            }
        }
        return transaction;
    }

    public static ModbusRequest createRequest(ModbusReadRequestBlueprint message) {
        ModbusRequest request;
        if (message.getFunctionCode() == ModbusReadFunctionCode.READ_COILS) {
            request = new ReadCoilsRequest(message.getReference(), message.getDataLength());
        } else if (message.getFunctionCode() == ModbusReadFunctionCode.READ_INPUT_DISCRETES) {
            request = new ReadInputDiscretesRequest(message.getReference(), message.getDataLength());
        } else if (message.getFunctionCode() == ModbusReadFunctionCode.READ_MULTIPLE_REGISTERS) {
            request = new ReadMultipleRegistersRequest(message.getReference(), message.getDataLength());
        } else if (message.getFunctionCode() == ModbusReadFunctionCode.READ_INPUT_REGISTERS) {
            request = new ReadInputRegistersRequest(message.getReference(), message.getDataLength());
        } else {
            throw new IllegalArgumentException(String.format("Unexpected function code %s", new Object[]{message.getFunctionCode()}));
        }
        request.setUnitID(message.getUnitID());
        request.setProtocolID(message.getProtocolID());
        return request;
    }

    public static BitVector convertBits(BitArray bits) {
        BitVector bitVector = new BitVector(bits.size());
        IntStream.range(0, bits.size()).forEach(i -> bitVector.setBit(i, bits.getBit(i)));
        return bitVector;
    }

    public static Register[] convertRegisters(ModbusRegisterArray arr) {
        return IntStream.range(0, arr.size()).mapToObj(i -> new SimpleInputRegister(arr.getRegister(i))).toList().toArray(new Register[0]);
    }

    public static int getNumberOfItemsInResponse(ModbusResponse response, ModbusReadRequestBlueprint request) {
        int responseCount;
        if (request.getFunctionCode() == ModbusReadFunctionCode.READ_COILS) {
            responseCount = ((ReadCoilsResponse)response).getCoils().size();
        } else if (request.getFunctionCode() == ModbusReadFunctionCode.READ_INPUT_DISCRETES) {
            responseCount = ((ReadInputDiscretesResponse)response).getDiscretes().size();
        } else if (request.getFunctionCode() == ModbusReadFunctionCode.READ_MULTIPLE_REGISTERS) {
            responseCount = ((ReadMultipleRegistersResponse)response).getRegisters().length;
        } else if (request.getFunctionCode() == ModbusReadFunctionCode.READ_INPUT_REGISTERS) {
            responseCount = ((ReadInputRegistersResponse)response).getRegisters().length;
        } else {
            throw new IllegalArgumentException(String.format("Unexpected function code %s", new Object[]{request.getFunctionCode()}));
        }
        return responseCount;
    }

    public static void invokeCallbackWithResponse(ModbusReadRequestBlueprint request, ModbusReadCallback callback, ModbusResponse response) {
        block6: {
            try {
                ModbusLibraryWrapper.getLogger().trace("Calling read response callback {} for request {}. Response was {}", new Object[]{callback, request, response});
                int dataItemsInResponse = ModbusLibraryWrapper.getNumberOfItemsInResponse(response, request);
                if (request.getFunctionCode() == ModbusReadFunctionCode.READ_COILS) {
                    BitVector bits = ((ReadCoilsResponse)response).getCoils();
                    BitArray payload = ModbusLibraryWrapper.bitArrayFromBitVector(bits, Math.min(dataItemsInResponse, request.getDataLength()));
                    callback.handle(new AsyncModbusReadResult(request, payload));
                    break block6;
                }
                if (request.getFunctionCode() == ModbusReadFunctionCode.READ_INPUT_DISCRETES) {
                    BitVector bits = ((ReadInputDiscretesResponse)response).getDiscretes();
                    BitArray payload = ModbusLibraryWrapper.bitArrayFromBitVector(bits, Math.min(dataItemsInResponse, request.getDataLength()));
                    callback.handle(new AsyncModbusReadResult(request, payload));
                    break block6;
                }
                if (request.getFunctionCode() == ModbusReadFunctionCode.READ_MULTIPLE_REGISTERS) {
                    ModbusRegisterArray payload = ModbusLibraryWrapper.modbusRegisterArrayFromInputRegisters(((ReadMultipleRegistersResponse)response).getRegisters());
                    callback.handle(new AsyncModbusReadResult(request, payload));
                    break block6;
                }
                if (request.getFunctionCode() == ModbusReadFunctionCode.READ_INPUT_REGISTERS) {
                    ModbusRegisterArray payload = ModbusLibraryWrapper.modbusRegisterArrayFromInputRegisters(((ReadInputRegistersResponse)response).getRegisters());
                    callback.handle(new AsyncModbusReadResult(request, payload));
                    break block6;
                }
                throw new IllegalArgumentException(String.format("Unexpected function code %s", new Object[]{request.getFunctionCode()}));
            }
            catch (Throwable throwable) {
                ModbusLibraryWrapper.getLogger().trace("Called read response callback {} for request {}. Response was {}", new Object[]{callback, request, response});
                throw throwable;
            }
        }
        ModbusLibraryWrapper.getLogger().trace("Called read response callback {} for request {}. Response was {}", new Object[]{callback, request, response});
    }
}

