/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.util.Iterator;
import java.util.List;
import org.netbeans.upgrade.systemoptions.SerParser;

final class Utils {
    private Utils() {
    }

    static String valueFromObjectWrapper(Object value) {
        String stringvalue = null;
        if (value instanceof SerParser.ObjectWrapper) {
            Object o;
            List<Object> l = ((SerParser.ObjectWrapper)value).data;
            if (l.size() == 1 && (o = l.get(0)) instanceof SerParser.NameValue) {
                stringvalue = ((SerParser.NameValue)o).value.toString();
            }
            if (stringvalue == null) {
                stringvalue = ((SerParser.ObjectWrapper)value).classdesc.name;
            }
        } else if (value instanceof String && !"null".equals(value)) {
            stringvalue = value.toString();
        } else if (value instanceof SerParser.ArrayWrapper && "[Ljava.lang.String;".equals(((SerParser.ArrayWrapper)value).classdesc.name)) {
            StringBuilder sb = new StringBuilder();
            List<Object> es = ((SerParser.ArrayWrapper)value).values;
            Iterator<Object> it = es.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(" , ");
            }
            stringvalue = sb.toString();
        } else if (value instanceof SerParser.ArrayWrapper && "[[Ljava.lang.String;".equals(((SerParser.ArrayWrapper)value).classdesc.name)) {
            StringBuilder sb = new StringBuilder();
            List<Object> awl = ((SerParser.ArrayWrapper)value).values;
            Iterator<Object> it = awl.iterator();
            while (it.hasNext()) {
                SerParser.ArrayWrapper aw = (SerParser.ArrayWrapper)it.next();
                sb.append(Utils.valueFromObjectWrapper(aw));
                if (!it.hasNext()) continue;
                sb.append(" | ");
            }
            stringvalue = sb.toString();
        } else {
            stringvalue = "unknown";
        }
        return stringvalue;
    }

    static String getClassNameFromObject(Object value) {
        String clsName = value instanceof SerParser.ObjectWrapper ? Utils.prettify(((SerParser.ObjectWrapper)value).classdesc.name) : (value instanceof SerParser.ArrayWrapper ? Utils.prettify(((SerParser.ArrayWrapper)value).classdesc.name) : Utils.prettify(value.getClass().getName()));
        return clsName;
    }

    static String prettify(String type) {
        if (type.equals("B")) {
            return "byte";
        }
        if (type.equals("S")) {
            return "short";
        }
        if (type.equals("I")) {
            return "int";
        }
        if (type.equals("J")) {
            return "long";
        }
        if (type.equals("F")) {
            return "float";
        }
        if (type.equals("D")) {
            return "double";
        }
        if (type.equals("C")) {
            return "char";
        }
        if (type.equals("Z")) {
            return "boolean";
        }
        if (type.startsWith("L") && type.endsWith(";")) {
            String fqn = type.substring(1, type.length() - 1).replace('/', '.').replace('$', '.');
            return fqn;
        }
        if (!type.startsWith("[")) {
            if (type.startsWith("L")) {
                return type.substring(1);
            }
            if (type.endsWith(";")) {
                return type.substring(0, type.length() - 1);
            }
        }
        return type;
    }
}

