/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.node.ToggleImportantInfo;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ToggleImportantAction
extends BaseAction {
    private String actionDisplayName;

    public String getName() {
        return this.actionDisplayName;
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean toggleImportant = false;
        boolean toggleUnImportant = false;
        for (Node node : activatedNodes) {
            ToggleImportantInfo tii = (ToggleImportantInfo)node.getLookup().lookup(ToggleImportantInfo.class);
            if (tii == null || tii.isDefault()) continue;
            if (tii.isImportant()) {
                toggleUnImportant = true;
                continue;
            }
            toggleImportant = true;
        }
        if (toggleUnImportant && toggleImportant) {
            this.actionDisplayName = NbBundle.getMessage(ToggleImportantAction.class, (String)"ToggleImportant");
            return true;
        }
        if (toggleUnImportant) {
            this.actionDisplayName = NbBundle.getMessage(ToggleImportantAction.class, (String)"ToggleImportantRemove");
            return true;
        }
        if (toggleImportant) {
            this.actionDisplayName = NbBundle.getMessage(ToggleImportantAction.class, (String)"ToggleImportantAdd");
            return true;
        }
        this.actionDisplayName = NbBundle.getMessage(ToggleImportantAction.class, (String)"ToggleImportant");
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            String name;
            DatabaseConnection conn = (DatabaseConnection)node.getLookup().lookup(DatabaseConnection.class);
            ToggleImportantInfo tii = (ToggleImportantInfo)node.getLookup().lookup(ToggleImportantInfo.class);
            if (conn != null && tii != null && Catalog.class.isAssignableFrom(tii.getType())) {
                name = node.getName();
                if (name.equals(conn.getDefaultCatalog())) {
                    tii.setDefault(true);
                    tii.setImportant(false);
                    conn.removeImportantCatalog(name);
                    continue;
                }
                if (!conn.isImportantCatalog(name)) {
                    conn.addImportantCatalog(name);
                    tii.setDefault(false);
                    tii.setImportant(true);
                    continue;
                }
                conn.removeImportantCatalog(name);
                tii.setDefault(false);
                tii.setImportant(false);
                continue;
            }
            if (conn == null || tii == null || !Schema.class.isAssignableFrom(tii.getType())) continue;
            name = node.getName();
            if (name.equals(conn.getDefaultSchema())) {
                tii.setDefault(true);
                tii.setImportant(false);
                conn.removeImportantSchema(name);
                continue;
            }
            if (!conn.isImportantSchema(name)) {
                conn.addImportantSchema(name);
                tii.setDefault(false);
                tii.setImportant(true);
                continue;
            }
            conn.removeImportantSchema(name);
            tii.setDefault(false);
            tii.setImportant(false);
        }
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

