/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetWorkloadMappingRequest
extends BmcRequest<Void> {
    private String clusterId;
    private String workloadMappingId;
    private String opcRequestId;

    public String getClusterId() {
        return this.clusterId;
    }

    public String getWorkloadMappingId() {
        return this.workloadMappingId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().clusterId(this.clusterId).workloadMappingId(this.workloadMappingId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",clusterId=").append(String.valueOf(this.clusterId));
        sb.append(",workloadMappingId=").append(String.valueOf(this.workloadMappingId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetWorkloadMappingRequest)) {
            return false;
        }
        GetWorkloadMappingRequest other = (GetWorkloadMappingRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.clusterId, other.clusterId) && Objects.equals(this.workloadMappingId, other.workloadMappingId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.clusterId == null ? 43 : this.clusterId.hashCode());
        result = result * 59 + (this.workloadMappingId == null ? 43 : this.workloadMappingId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetWorkloadMappingRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String clusterId = null;
        private String workloadMappingId = null;
        private String opcRequestId = null;

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder workloadMappingId(String workloadMappingId) {
            this.workloadMappingId = workloadMappingId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetWorkloadMappingRequest o) {
            this.clusterId(o.getClusterId());
            this.workloadMappingId(o.getWorkloadMappingId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetWorkloadMappingRequest build() {
            GetWorkloadMappingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetWorkloadMappingRequest buildWithoutInvocationCallback() {
            GetWorkloadMappingRequest request = new GetWorkloadMappingRequest();
            request.clusterId = this.clusterId;
            request.workloadMappingId = this.workloadMappingId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

