/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.impl;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.spi.HudsonLogger;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;

public class HudsonLoggerHelper {
    private static final Logger LOG = Logger.getLogger(HudsonLogger.class.getName());

    public static void openAt(FileObject f, int row, final int col, final boolean force) {
        try {
            DataObject d = DataObject.find((FileObject)f);
            if (row == -1) {
                if (force) {
                    Runnable r;
                    final EditorCookie c = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
                    if (c != null) {
                        r = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    c.openDocument();
                                }
                                catch (IOException x) {
                                    LOG.log(Level.INFO, null, x);
                                }
                            }
                        };
                    } else {
                        LOG.fine("no EditorCookie found for " + f);
                        final OpenCookie o = (OpenCookie)d.getLookup().lookup(OpenCookie.class);
                        if (o == null) {
                            LOG.fine("no OpenCookie found for " + f);
                            return;
                        }
                        r = new Runnable(){

                            @Override
                            public void run() {
                                o.open();
                            }
                        };
                    }
                    EventQueue.invokeLater(r);
                }
                return;
            }
            LineCookie c = (LineCookie)d.getLookup().lookup(LineCookie.class);
            if (c == null) {
                LOG.fine("no LineCookie found for " + f);
                HudsonLoggerHelper.openAt(f, -1, -1, force);
                return;
            }
            try {
                final Line l = c.getLineSet().getOriginal(row);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        l.show(force ? Line.ShowOpenType.REUSE : Line.ShowOpenType.NONE, force ? Line.ShowVisibilityType.FOCUS : Line.ShowVisibilityType.FRONT, col);
                    }
                });
            }
            catch (IndexOutOfBoundsException x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        catch (IOException x) {
            LOG.log(Level.INFO, null, x);
        }
    }
}

