/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.admin;

import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.modules.glassfish.tooling.GlassFishIdeException;
import org.netbeans.modules.glassfish.tooling.admin.Command;
import org.netbeans.modules.glassfish.tooling.admin.ResultString;
import org.netbeans.modules.glassfish.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.glassfish.tooling.admin.RunnerHttpCreateJDBCConnectionPool;
import org.netbeans.modules.glassfish.tooling.admin.RunnerRestClass;
import org.netbeans.modules.glassfish.tooling.admin.RunnerRestCreateJDBCConnectionPool;
import org.netbeans.modules.glassfish.tooling.admin.ServerAdmin;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;

@RunnerHttpClass(runner=RunnerHttpCreateJDBCConnectionPool.class)
@RunnerRestClass(runner=RunnerRestCreateJDBCConnectionPool.class)
public class CommandCreateJDBCConnectionPool
extends Command {
    private static final String COMMAND = "create-jdbc-connection-pool";
    private static final String ERROR_MESSAGE = "Create JDBC connection pool failed.";
    final String connectionPoolId;
    final String dataSourceClassName;
    final String resType;
    final Map<String, String> properties;

    public static ResultString createJDBCConnectionPool(GlassFishServer server, String connectionPoolId, String dataSourceClassName, String resType, Map<String, String> properties) throws GlassFishIdeException {
        CommandCreateJDBCConnectionPool command = new CommandCreateJDBCConnectionPool(connectionPoolId, dataSourceClassName, resType, properties);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(ERROR_MESSAGE, ie);
        }
    }

    public static ResultString createJDBCConnectionPool(GlassFishServer server, String connectionPoolId, String dataSourceClassName, String resType, Map<String, String> properties, long timeout) throws GlassFishIdeException {
        CommandCreateJDBCConnectionPool command = new CommandCreateJDBCConnectionPool(connectionPoolId, dataSourceClassName, resType, properties);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(ERROR_MESSAGE, ie);
        }
        catch (TimeoutException te) {
            throw new GlassFishIdeException("Create JDBC connection pool failed. in " + timeout + "ms", te);
        }
    }

    public CommandCreateJDBCConnectionPool(String connectionPoolId, String dataSourceClassName, String resType, Map<String, String> properties) {
        super(COMMAND);
        this.connectionPoolId = connectionPoolId;
        this.dataSourceClassName = dataSourceClassName;
        this.resType = resType;
        this.properties = properties;
    }
}

