/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.options;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.ui.analyzer.PHPStanCustomizerPanel;
import org.netbeans.modules.php.analysis.ui.options.PHPStanOptionsPanel;
import org.netbeans.modules.php.api.util.StringUtils;

public final class ValidatorPHPStanParameter {
    @NullAllowed
    private final String phpStanPath;
    @NullAllowed
    private final String configuration;
    @NullAllowed
    private final String memoryLimit;

    public static ValidatorPHPStanParameter create(PHPStanOptionsPanel panel) {
        return new ValidatorPHPStanParameter(panel);
    }

    public static ValidatorPHPStanParameter create(PHPStanCustomizerPanel panel) {
        return new ValidatorPHPStanParameter(panel);
    }

    private ValidatorPHPStanParameter() {
        this.phpStanPath = null;
        this.configuration = null;
        this.memoryLimit = null;
    }

    private ValidatorPHPStanParameter(PHPStanOptionsPanel panel) {
        this.phpStanPath = panel.getPHPStanPath();
        this.configuration = panel.getPHPStanConfigurationPath();
        this.memoryLimit = panel.getPHPStanMemoryLimit();
    }

    private ValidatorPHPStanParameter(PHPStanCustomizerPanel panel) {
        this.phpStanPath = StringUtils.hasText((String)panel.getPHPStanPath()) ? panel.getPHPStanPath() : AnalysisOptions.getInstance().getPHPStanPath();
        this.configuration = panel.getConfiguration();
        this.memoryLimit = panel.getMemoryLimit();
    }

    @CheckForNull
    public String getPHPStanPath() {
        return this.phpStanPath;
    }

    @CheckForNull
    public String getConfiguration() {
        return this.configuration;
    }

    @CheckForNull
    public String getMemoryLimit() {
        return this.memoryLimit;
    }
}

