/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Collection;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttlistDeclAttributeDef;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.ParameterEntityReference;

public class TreeAttlistDecl
extends TreeNodeDecl
implements DTD.Child,
ParameterEntityReference.Child,
DocumentType.Child,
ConditionalSection.Child {
    public static final String PROP_ELEMENT_NAME = "elementName";
    public static final String PROP_ATTRIBUTE_DEF_MAP_ADD = "map.add";
    public static final String PROP_ATTRIBUTE_DEF_MAP_REMOVE = "map.remove";
    public static final String PROP_ATTRIBUTE_DEF_MAP_CONTENT = "map.content";
    private String elementName;
    private TreeNamedObjectMap attributeDefs;

    public TreeAttlistDecl(String elementName) throws InvalidArgumentException {
        this.checkElementName(elementName);
        this.elementName = elementName;
        this.attributeDefs = new TreeNamedObjectMap(this.createAttlistContentManager());
    }

    protected TreeAttlistDecl(TreeAttlistDecl attlistDecl) {
        super(attlistDecl);
        this.elementName = attlistDecl.elementName;
        this.attributeDefs = new TreeNamedObjectMap(this.createAttlistContentManager());
        this.attributeDefs.addAll((Collection)((TreeNamedObjectMap)attlistDecl.attributeDefs.clone()));
    }

    @Override
    public Object clone() {
        return new TreeAttlistDecl(this);
    }

    @Override
    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeAttlistDecl peer = (TreeAttlistDecl)object;
        if (!Util.equals(this.getElementName(), peer.getElementName())) {
            return false;
        }
        return Util.equals(this.attributeDefs, peer.attributeDefs);
    }

    @Override
    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeAttlistDecl peer = (TreeAttlistDecl)treeObject;
        this.setElementNameImpl(peer.getElementName());
        this.attributeDefs.merge(peer.attributeDefs);
    }

    @Override
    protected void setReadOnly(boolean newReadOnly) {
        super.setReadOnly(newReadOnly);
        this.attributeDefs.setReadOnly(newReadOnly);
    }

    public final String getElementName() {
        return this.elementName;
    }

    private final void setElementNameImpl(String newElementName) {
        String oldElementName = this.elementName;
        this.elementName = newElementName;
        this.firePropertyChange(PROP_ELEMENT_NAME, oldElementName, newElementName);
    }

    public final void setElementName(String newElementName) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.elementName, newElementName)) {
            return;
        }
        this.checkReadOnly();
        this.checkElementName(newElementName);
        this.setElementNameImpl(newElementName);
    }

    protected final void checkElementName(String elementName) throws InvalidArgumentException {
        TreeUtilities.checkAttlistDeclElementName(elementName);
    }

    public final TreeAttlistDeclAttributeDef getAttributeDef(String attributeDefName) {
        return (TreeAttlistDeclAttributeDef)this.attributeDefs.get(attributeDefName);
    }

    private final void setAttributeDefImpl(TreeAttlistDeclAttributeDef newAttributeDef) {
        TreeAttlistDeclAttributeDef oldAttributeDef = (TreeAttlistDeclAttributeDef)this.attributeDefs.get(newAttributeDef.getName());
        this.attributeDefs.add(newAttributeDef);
        this.firePropertyChange(PROP_ATTRIBUTE_DEF_MAP_ADD, oldAttributeDef, newAttributeDef);
    }

    public final void setAttributeDef(TreeAttlistDeclAttributeDef newAttributeDef) throws ReadOnlyException, InvalidArgumentException {
        TreeAttlistDeclAttributeDef oldAttributeDef = (TreeAttlistDeclAttributeDef)this.attributeDefs.get(newAttributeDef.getName());
        if (Util.equals(oldAttributeDef, newAttributeDef)) {
            return;
        }
        this.checkReadOnly();
        this.setAttributeDefImpl(newAttributeDef);
    }

    private final TreeAttlistDeclAttributeDef removeAttributeDefImpl(String attributeDefName) {
        TreeAttlistDeclAttributeDef oldAttributeDef = (TreeAttlistDeclAttributeDef)this.attributeDefs.get(attributeDefName);
        this.attributeDefs.remove(oldAttributeDef);
        this.firePropertyChange(PROP_ATTRIBUTE_DEF_MAP_REMOVE, oldAttributeDef, null);
        return oldAttributeDef;
    }

    public final TreeAttlistDeclAttributeDef removeAttributeDef(String attributeDefName) throws ReadOnlyException {
        this.checkReadOnly();
        return this.removeAttributeDefImpl(attributeDefName);
    }

    public final TreeNamedObjectMap getAttributeDefs() {
        return this.attributeDefs;
    }

    protected TreeNamedObjectMap.ContentManager createAttlistContentManager() {
        return new AttlistContentManager();
    }

    protected class AttlistContentManager
    extends TreeNamedObjectMap.ContentManager {
        protected AttlistContentManager() {
        }

        @Override
        public TreeNode getOwnerNode() {
            return TreeAttlistDecl.this;
        }

        @Override
        public void checkAssignableObject(Object obj) {
            super.checkAssignableObject(obj);
            this.checkAssignableClass(TreeAttlistDeclAttributeDef.class, obj);
        }

        @Override
        public void objectInserted(TreeObject obj) {
            ((TreeAttlistDeclAttributeDef)obj).setNodeDecl(TreeAttlistDecl.this);
        }

        @Override
        public void objectRemoved(TreeObject obj) {
            ((TreeAttlistDeclAttributeDef)obj).setNodeDecl(null);
        }

        @Override
        public void orderChanged(int[] permutation) {
        }
    }
}

