/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CommonAttributeVisualPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ConnectionPoolOptionalVisualPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceWizardPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Util;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroupHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;

public class CommonAttributePanel
extends ResourceWizardPanel {
    private Component component;
    private ResourceConfigHelper helper;
    private Wizard wizardInfo;
    private String[] groupNames;
    private boolean setupValid = true;
    private String panelType;
    private boolean isConnPool = false;

    public CommonAttributePanel(ResourceConfigHelper helper, Wizard wizardInfo, String[] groupNames) {
        this.helper = helper;
        this.wizardInfo = wizardInfo;
        this.groupNames = groupNames;
    }

    public Component getComponent() {
        if (this.component == null) {
            FieldGroup[] groups = new FieldGroup[this.groupNames.length];
            for (int i = 0; i < this.groupNames.length; ++i) {
                groups[i] = FieldGroupHelper.getFieldGroup(this.wizardInfo, this.groupNames[i]);
            }
            if (this.wizardInfo.getName().equals("jdbc-connection-pool")) {
                this.panelType = "_CP_SETTING";
                this.component = new ConnectionPoolOptionalVisualPanel(this, this.helper);
            } else if (this.wizardInfo.getName().equals("jdbc-resource")) {
                this.panelType = "_DS";
                this.component = new CommonAttributeVisualPanel(this, groups, this.panelType, this.helper);
            } else if (this.wizardInfo.getName().equals("persistence-manager-factory-resource")) {
                this.panelType = "_PM";
                this.component = new CommonAttributeVisualPanel(this, groups, this.panelType, this.helper);
            }
            this.setIsConnPool();
        }
        return this.component;
    }

    public boolean isNewResourceSelected() {
        if (this.component == null) {
            return false;
        }
        if (!this.getIsConnPool()) {
            return ((CommonAttributeVisualPanel)this.component).isNewResourceSelected();
        }
        return false;
    }

    public void setInitialFocus() {
        if (this.component != null && !this.getIsConnPool()) {
            ((CommonAttributeVisualPanel)this.component).setInitialFocus();
        }
    }

    public void setPropInitialFocus() {
        if (this.component != null && !this.getIsConnPool()) {
            ((CommonAttributeVisualPanel)this.component).setPropInitialFocus();
        }
    }

    public String getResourceName() {
        return this.wizardInfo.getName();
    }

    @Override
    public HelpCtx getHelp() {
        if (this.wizardInfo.getName().equals("jdbc-connection-pool")) {
            return new HelpCtx("AS_Wiz_ConnPool_poolSettings");
        }
        if (this.wizardInfo.getName().equals("jdbc-resource")) {
            return new HelpCtx("AS_Wiz_DataSource_general");
        }
        if (this.wizardInfo.getName().equals("persistence-manager-factory-resource")) {
            return new HelpCtx("AS_Wiz_PMF_general");
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public ResourceConfigHelper getHelper() {
        return this.helper;
    }

    public Wizard getWizard() {
        return this.wizardInfo;
    }

    public boolean isValid() {
        if (!this.setupValid) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidSetup"));
            return false;
        }
        this.setErrorMsg(this.bundle.getString("Empty_String"));
        if (!this.getIsConnPool()) {
            CommonAttributeVisualPanel visComponent = (CommonAttributeVisualPanel)this.component;
            if (visComponent != null && visComponent.jLabels != null && visComponent.jFields != null) {
                for (int i = 0; i < visComponent.jLabels.length; ++i) {
                    String jLabel = visComponent.jLabels[i].getText();
                    if (!jLabel.equals(Util.getCorrectedLabel(this.bundle, "jndi-name"))) continue;
                    String jndiName = ((JTextField)visComponent.jFields[i]).getText();
                    if (jndiName == null || jndiName.length() == 0) {
                        this.setErrorMsg(this.bundle.getString("Err_InvalidJndiName"));
                        return false;
                    }
                    if (!ResourceUtils.isLegalResourceName(jndiName)) {
                        this.setErrorMsg(this.bundle.getString("Err_InvalidJndiName"));
                        return false;
                    }
                    FileObject resFolder = this.helper.getData().getTargetFileObject();
                    if (resFolder == null) continue;
                    if (this.wizardInfo.getName().equals("jdbc-resource")) {
                        if (ResourceUtils.isUniqueFileName(jndiName, resFolder, "jdbc/myDatasource")) continue;
                        this.setErrorMsg(this.bundle.getString("Err_DuplFileJndiName"));
                        return false;
                    }
                    if (!this.wizardInfo.getName().equals("persistence-manager-factory-resource") || ResourceUtils.isUniqueFileName(jndiName, resFolder, "persistence")) continue;
                    this.setErrorMsg(this.bundle.getString("Err_DuplFileJndiName"));
                    return false;
                }
            }
            if (!this.isNewResourceSelected()) {
                String cpname;
                if (this.helper.getData().getResourceName().equals("jdbc-resource") && ((cpname = this.helper.getData().getString("pool-name")) == null || cpname.trim().equals(""))) {
                    this.setErrorMsg(this.bundle.getString("Err_ChooseOrCreatePool"));
                    return false;
                }
                if (this.helper.getData().getResourceName().equals("persistence-manager-factory-resource")) {
                    if (this.helper.getData().getHolder().hasDSHelper()) {
                        cpname = this.helper.getData().getHolder().getDSHelper().getData().getString("pool-name");
                        if (cpname == null || cpname.trim().equals("")) {
                            this.setErrorMsg(this.bundle.getString("Err_ChooseOrCreatePool"));
                            return false;
                        }
                    } else {
                        String dsname = this.helper.getData().getString("jdbc-resource-jndi-name");
                        if (dsname == null || dsname.trim().equals("")) {
                            this.setErrorMsg(this.bundle.getString("Err_ChooseOrCreateDS"));
                            return false;
                        }
                    }
                }
            }
        } else {
            ConnectionPoolOptionalVisualPanel visComponent = (ConnectionPoolOptionalVisualPanel)this.component;
            return visComponent.hasValidData();
        }
        return true;
    }

    public void initData() {
        if (!this.getIsConnPool()) {
            CommonAttributeVisualPanel visComponent = (CommonAttributeVisualPanel)this.component;
            visComponent.initData();
        }
    }

    @Override
    public void readSettings(Object settings) {
        this.wizDescriptor = (WizardDescriptor)settings;
        TemplateWizard wizard = (TemplateWizard)settings;
        String targetName = wizard.getTargetName();
        FileObject resFolder = ResourceUtils.getResourceDirectory(this.helper.getData().getTargetFileObject());
        this.helper.getData().setTargetFileObject(resFolder);
        if (this.component == null) {
            this.getComponent();
        }
        if (resFolder != null) {
            String resourceName = this.helper.getData().getString("jndi-name");
            if (resourceName != null && !resourceName.equals("")) {
                this.helper.getData().setTargetFile(resourceName);
            } else if (this.wizardInfo.getName().equals("jdbc-resource")) {
                if (this.helper.getData().getString("dynamicPanel").equals("true")) {
                    targetName = null;
                }
                targetName = ResourceUtils.createUniqueFileName(targetName, resFolder, "jdbc/myDatasource");
                this.helper.getData().setTargetFile(targetName);
            } else if (this.wizardInfo.getName().equals("persistence-manager-factory-resource")) {
                targetName = ResourceUtils.createUniqueFileName(targetName, resFolder, "persistence");
                this.helper.getData().setTargetFile(targetName);
            }
            if (!this.getIsConnPool()) {
                CommonAttributeVisualPanel visComponent = (CommonAttributeVisualPanel)this.component;
                visComponent.setHelper(this.helper);
            }
        } else {
            this.setupValid = false;
        }
    }

    @Override
    public boolean isFinishPanel() {
        if (this.isNewResourceSelected()) {
            return false;
        }
        return this.isValid();
    }

    private boolean setupValid() {
        return this.setupValid;
    }

    private void setIsConnPool() {
        this.isConnPool = !this.panelType.equals("_DS") && !this.panelType.equals("_PM");
    }

    private boolean getIsConnPool() {
        return this.isConnPool;
    }
}

