/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.tooling.TaskState;
import org.netbeans.modules.glassfish.tooling.admin.CommandListResources;
import org.netbeans.modules.glassfish.tooling.admin.ResultList;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;

public class ResourceDesc
implements Comparable<ResourceDesc> {
    private static final Logger LOGGER = GlassFishLogger.get(ResourceDesc.class);
    private final String name;
    private final String cmdType;

    public static List<ResourceDesc> getResources(GlassfishInstance instance, String type) {
        List<ResourceDesc> resourcesList;
        ResultList result = CommandListResources.listResources((GlassFishServer)instance, (String)type, null);
        List values = result != null && result.getState() == TaskState.COMPLETED ? result.getValue() : null;
        if (values != null && values.size() > 0) {
            resourcesList = new ArrayList<ResourceDesc>(values.size());
            for (String value : values) {
                resourcesList.add(new ResourceDesc(value, type));
            }
        } else {
            resourcesList = Collections.emptyList();
        }
        return resourcesList;
    }

    public ResourceDesc(String name, String cmdType) {
        this.name = name;
        this.cmdType = cmdType;
    }

    public String getName() {
        return this.name;
    }

    public String getCommandType() {
        return this.cmdType;
    }

    @Override
    public int compareTo(ResourceDesc resourceDesc) {
        int result = this.name.compareTo(resourceDesc.name);
        if (result == 0) {
            result = this.cmdType.compareTo(resourceDesc.cmdType);
        }
        return result;
    }
}

