/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.run;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.phpunit.commands.PhpUnit;
import org.netbeans.modules.php.phpunit.preferences.PhpUnitPreferences;
import org.netbeans.modules.php.phpunit.run.PhpUnitLogParser;
import org.netbeans.modules.php.phpunit.run.TestCaseVo;
import org.netbeans.modules.php.phpunit.run.TestSessionVo;
import org.netbeans.modules.php.phpunit.run.TestSuiteVo;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.run.TestCase;
import org.netbeans.modules.php.spi.testing.run.TestRunException;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;
import org.netbeans.modules.php.spi.testing.run.TestSession;
import org.netbeans.modules.php.spi.testing.run.TestSuite;

public final class TestRunner {
    private static final Logger LOGGER = Logger.getLogger(TestRunner.class.getName());
    private final PhpModule phpModule;

    public TestRunner(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public void runTests(TestRunInfo runInfo, TestSession testSession) throws TestRunException {
        PhpUnit phpUnit = PhpUnit.getForPhpModule(this.phpModule, true);
        if (phpUnit == null) {
            throw new TestRunException();
        }
        Integer result = phpUnit.runTests(this.phpModule, runInfo);
        if (result == null) {
            throw new TestRunException();
        }
        TestSessionVo sessionVo = this.createTestSession(PhpUnit.XML_LOG);
        if (sessionVo != null) {
            this.map(sessionVo, testSession);
        }
    }

    @CheckForNull
    private TestSessionVo createTestSession(File xmlLog) throws TestRunException {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlLog), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException ex) {
            this.processPhpUnitError(ex);
            return null;
        }
        TestSessionVo session = new TestSessionVo(this.getCustomTestSuite());
        boolean parsed = PhpUnitLogParser.parse(reader, session);
        if (!parsed) {
            this.processPhpUnitError(null);
            return null;
        }
        return session;
    }

    private String getCustomTestSuite() {
        if (PhpUnitPreferences.isCustomSuiteEnabled(this.phpModule)) {
            return PhpUnitPreferences.getCustomSuitePath(this.phpModule);
        }
        return null;
    }

    private void processPhpUnitError(Exception cause) throws TestRunException {
        LOGGER.info(String.format("File %s not found or cannot be parsed. If there are no errors in PHPUnit output (verify in Output window), please report an issue (http://www.netbeans.org/issues/).", PhpUnit.XML_LOG));
        throw new TestRunException((Throwable)cause);
    }

    private void map(TestSessionVo sessionVo, TestSession testSession) {
        testSession.setOutputLineHandler(sessionVo.getOutputLineHandler());
        String initMessage = sessionVo.getInitMessage();
        if (initMessage != null) {
            testSession.printMessage(initMessage, false);
            testSession.printMessage("", false);
        }
        for (TestSuiteVo suiteVo : sessionVo.getTestSuites()) {
            TestSuite testSuite = testSession.addTestSuite(suiteVo.getName(), suiteVo.getLocation());
            for (TestCaseVo caseVo : suiteVo.getTestCases()) {
                Locations.Line location;
                TestCase testCase = testSuite.addTestCase(caseVo.getName(), caseVo.getType());
                String className = caseVo.getClassName();
                if (className != null) {
                    testCase.setClassName(className);
                }
                if ((location = caseVo.getLocation()) != null) {
                    testCase.setLocation(location);
                }
                testCase.setStatus(caseVo.getStatus());
                boolean error = caseVo.isError();
                if (error || caseVo.isFailure()) {
                    String[] tmp;
                    String[] stackTrace = caseVo.getStackTrace();
                    if (stackTrace.length == 1) {
                        tmp = new String[]{};
                    } else {
                        tmp = new String[stackTrace.length - 1];
                        System.arraycopy(stackTrace, 1, tmp, 0, stackTrace.length - 1);
                    }
                    testCase.setFailureInfo(stackTrace[0], tmp, error, caseVo.getDiff());
                }
                testCase.setTime(caseVo.getTime());
            }
            testSuite.finish(suiteVo.getTime());
        }
        String finishMessage = sessionVo.getFinishMessage();
        if (finishMessage != null) {
            testSession.printMessage(finishMessage, false);
        }
    }
}

