/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme;

public final class FontStyle {
    public static final int NotSet = -1;
    public static final int None = 0;
    public static final int Italic = 1;
    public static final int Bold = 2;
    public static final int Underline = 4;
    public static final int Strikethrough = 8;

    public static String fontStyleToString(int fontStyle) {
        if (fontStyle == -1) {
            return "not set";
        }
        if (fontStyle == 0) {
            return "none";
        }
        StringBuilder style = new StringBuilder();
        if (FontStyle.isItalic(fontStyle)) {
            style.append("italic ");
        }
        if (FontStyle.isBold(fontStyle)) {
            style.append("bold ");
        }
        if (FontStyle.isUnderline(fontStyle)) {
            style.append("underline ");
        }
        if (FontStyle.isStrikethrough(fontStyle)) {
            style.append("strikethrough ");
        }
        if (style.isEmpty()) {
            return "none";
        }
        style.setLength(style.length() - 1);
        return style.toString();
    }

    public static boolean isBold(int fontStyle) {
        return (fontStyle & 2) == 2;
    }

    public static boolean isItalic(int fontStyle) {
        return (fontStyle & 1) == 1;
    }

    public static boolean isUnderline(int fontStyle) {
        return (fontStyle & 4) == 4;
    }

    public static boolean isStrikethrough(int fontStyle) {
        return (fontStyle & 8) == 8;
    }

    private FontStyle() {
    }
}

