/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.ModulesActivator;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.openide.awt.CheckForUpdatesProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

final class InstallOrActivateTask
implements Runnable,
FileChangeListener {
    private final ModulesInstaller installer;
    private final ModulesActivator activator;
    private final List<FileObject> changed = new ArrayList<FileObject>();

    InstallOrActivateTask(ModulesInstaller installer) {
        this.installer = installer;
        this.activator = null;
    }

    InstallOrActivateTask(ModulesActivator activator) {
        this.activator = activator;
        this.installer = null;
    }

    @Override
    public void run() {
        FileObject fo = FileUtil.getConfigFile((String)"Modules");
        try {
            if (fo != null) {
                fo.addFileChangeListener((FileChangeListener)this);
            }
            if (this.installer != null) {
                this.installer.installMissingModules();
            }
            if (this.activator != null) {
                this.activator.enableModules();
            }
        }
        finally {
            if (fo != null) {
                fo.removeFileChangeListener((FileChangeListener)this);
                FeatureManager.associateFiles(this.getChangedFiles());
            }
            this.notifyUpdates();
        }
    }

    private void notifyUpdates() {
        assert (!EventQueue.isDispatchThread()) : "Don't call it from event dispatch thread.";
        CheckForUpdatesProvider checkForUpdatesProvider = (CheckForUpdatesProvider)Lookup.getDefault().lookup(CheckForUpdatesProvider.class);
        if (checkForUpdatesProvider == null) {
            Logger.getLogger(InstallOrActivateTask.class.getName()).log(Level.WARNING, "CheckForUpdatesProvider not found in Lookup.getDefault(): " + Lookup.getDefault());
            return;
        }
        boolean anyUpdates = checkForUpdatesProvider.notifyAvailableUpdates(false);
        Logger.getLogger(InstallOrActivateTask.class.getName()).log(Level.FINE, "Any updates? " + anyUpdates);
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public synchronized void fileDataCreated(FileEvent fe) {
        this.changed.add(fe.getFile());
    }

    public synchronized void fileChanged(FileEvent fe) {
        this.changed.add(fe.getFile());
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private synchronized List<FileObject> getChangedFiles() {
        return new ArrayList<FileObject>(this.changed);
    }
}

