/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.classpath;

import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.java.classpath.AbstractSourceSetClassPathImpl;
import org.netbeans.modules.gradle.java.execute.JavaRunUtils;
import org.netbeans.modules.gradle.java.spi.support.JavaToolchainSupport;

public final class BootClassPathImpl
extends AbstractSourceSetClassPathImpl {
    private static final String PROTOCOL_NBJRT = "nbjrt";
    final boolean modulesOnly;

    public BootClassPathImpl(Project proj, String group) {
        this(proj, group, false);
    }

    public BootClassPathImpl(Project proj, String group, boolean modulesOnly) {
        super(proj, group);
        this.modulesOnly = modulesOnly;
    }

    @Override
    protected List<URL> createPath() {
        JavaToolchainSupport toolchain = JavaToolchainSupport.getDefault();
        GradleJavaSourceSet ss = this.getSourceSet();
        File jh = ss != null ? ss.getCompilerJavaHome(GradleJavaSourceSet.SourceType.JAVA) : null;
        JavaPlatform platform = jh != null ? toolchain.platformByHome(jh) : (JavaPlatform)JavaRunUtils.getActivePlatform(this.project).second();
        LinkedList<URL> ret = new LinkedList<URL>();
        if (platform != null) {
            for (ClassPath.Entry entry : platform.getBootstrapLibraries().entries()) {
                URL root = entry.getURL();
                if (this.modulesOnly && !PROTOCOL_NBJRT.equals(root.getProtocol())) continue;
                ret.add(root);
            }
        }
        return ret;
    }
}

