/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct CUipcMemHandle")
public class CUIPCMemHandle
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;

    public CUIPCMemHandle(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUIPCMemHandle.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[CU_IPC_HANDLE_SIZE]")
    public ByteBuffer reserved() {
        return CUIPCMemHandle.nreserved(this.address());
    }

    @NativeType(value="char")
    public byte reserved(int index) {
        return CUIPCMemHandle.nreserved(this.address(), index);
    }

    public CUIPCMemHandle reserved(@NativeType(value="char[CU_IPC_HANDLE_SIZE]") ByteBuffer value) {
        CUIPCMemHandle.nreserved(this.address(), value);
        return this;
    }

    public CUIPCMemHandle reserved(int index, @NativeType(value="char") byte value) {
        CUIPCMemHandle.nreserved(this.address(), index, value);
        return this;
    }

    public CUIPCMemHandle set(CUIPCMemHandle src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUIPCMemHandle malloc() {
        return (CUIPCMemHandle)CUIPCMemHandle.wrap(CUIPCMemHandle.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUIPCMemHandle calloc() {
        return (CUIPCMemHandle)CUIPCMemHandle.wrap(CUIPCMemHandle.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUIPCMemHandle create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUIPCMemHandle)CUIPCMemHandle.wrap(CUIPCMemHandle.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUIPCMemHandle create(long address) {
        return (CUIPCMemHandle)CUIPCMemHandle.wrap(CUIPCMemHandle.class, (long)address);
    }

    @Nullable
    public static CUIPCMemHandle createSafe(long address) {
        return address == 0L ? null : (CUIPCMemHandle)CUIPCMemHandle.wrap(CUIPCMemHandle.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUIPCMemHandle.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUIPCMemHandle.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUIPCMemHandle.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUIPCMemHandle.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUIPCMemHandle.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUIPCMemHandle.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUIPCMemHandle.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static CUIPCMemHandle mallocStack() {
        return CUIPCMemHandle.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUIPCMemHandle callocStack() {
        return CUIPCMemHandle.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUIPCMemHandle mallocStack(MemoryStack stack) {
        return CUIPCMemHandle.malloc(stack);
    }

    @Deprecated
    public static CUIPCMemHandle callocStack(MemoryStack stack) {
        return CUIPCMemHandle.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUIPCMemHandle.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUIPCMemHandle.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUIPCMemHandle.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUIPCMemHandle.calloc(capacity, stack);
    }

    public static CUIPCMemHandle malloc(MemoryStack stack) {
        return (CUIPCMemHandle)CUIPCMemHandle.wrap(CUIPCMemHandle.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUIPCMemHandle calloc(MemoryStack stack) {
        return (CUIPCMemHandle)CUIPCMemHandle.wrap(CUIPCMemHandle.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUIPCMemHandle.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUIPCMemHandle.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nreserved(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED), (int)64);
    }

    public static byte nreserved(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)RESERVED + Checks.check((int)index, (int)64) * 1L);
    }

    public static void nreserved(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)64);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)RESERVED), (long)(value.remaining() * 1));
    }

    public static void nreserved(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED + Checks.check((int)index, (int)64) * 1L, value);
    }

    static {
        Struct.Layout layout = CUIPCMemHandle.__struct((Struct.Member[])new Struct.Member[]{CUIPCMemHandle.__array((int)1, (int)64)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CUIPCMemHandle, Buffer>
    implements NativeResource {
        private static final CUIPCMemHandle ELEMENT_FACTORY = CUIPCMemHandle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUIPCMemHandle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[CU_IPC_HANDLE_SIZE]")
        public ByteBuffer reserved() {
            return CUIPCMemHandle.nreserved(this.address());
        }

        @NativeType(value="char")
        public byte reserved(int index) {
            return CUIPCMemHandle.nreserved(this.address(), index);
        }

        public Buffer reserved(@NativeType(value="char[CU_IPC_HANDLE_SIZE]") ByteBuffer value) {
            CUIPCMemHandle.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="char") byte value) {
            CUIPCMemHandle.nreserved(this.address(), index, value);
            return this;
        }
    }
}

