/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryBarrier
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCACCESSMASK;
    public static final int DSTACCESSMASK;

    public VkMemoryBarrier(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryBarrier.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryBarrier.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryBarrier.npNext(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int srcAccessMask() {
        return VkMemoryBarrier.nsrcAccessMask(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int dstAccessMask() {
        return VkMemoryBarrier.ndstAccessMask(this.address());
    }

    public VkMemoryBarrier sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryBarrier.nsType(this.address(), value);
        return this;
    }

    public VkMemoryBarrier sType$Default() {
        return this.sType(46);
    }

    public VkMemoryBarrier pNext(@NativeType(value="void const *") long value) {
        VkMemoryBarrier.npNext(this.address(), value);
        return this;
    }

    public VkMemoryBarrier srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkMemoryBarrier.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkMemoryBarrier dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkMemoryBarrier.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkMemoryBarrier set(int sType, long pNext, int srcAccessMask, int dstAccessMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcAccessMask(srcAccessMask);
        this.dstAccessMask(dstAccessMask);
        return this;
    }

    public VkMemoryBarrier set(VkMemoryBarrier src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryBarrier malloc() {
        return (VkMemoryBarrier)VkMemoryBarrier.wrap(VkMemoryBarrier.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkMemoryBarrier calloc() {
        return (VkMemoryBarrier)VkMemoryBarrier.wrap(VkMemoryBarrier.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkMemoryBarrier create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkMemoryBarrier)VkMemoryBarrier.wrap(VkMemoryBarrier.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkMemoryBarrier create(long address) {
        return (VkMemoryBarrier)VkMemoryBarrier.wrap(VkMemoryBarrier.class, (long)address);
    }

    @Nullable
    public static VkMemoryBarrier createSafe(long address) {
        return address == 0L ? null : (VkMemoryBarrier)VkMemoryBarrier.wrap(VkMemoryBarrier.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkMemoryBarrier.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkMemoryBarrier.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkMemoryBarrier.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryBarrier.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkMemoryBarrier.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkMemoryBarrier.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkMemoryBarrier.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkMemoryBarrier mallocStack() {
        return VkMemoryBarrier.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryBarrier callocStack() {
        return VkMemoryBarrier.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryBarrier mallocStack(MemoryStack stack) {
        return VkMemoryBarrier.malloc(stack);
    }

    @Deprecated
    public static VkMemoryBarrier callocStack(MemoryStack stack) {
        return VkMemoryBarrier.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryBarrier.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryBarrier.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryBarrier.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryBarrier.calloc(capacity, stack);
    }

    public static VkMemoryBarrier malloc(MemoryStack stack) {
        return (VkMemoryBarrier)VkMemoryBarrier.wrap(VkMemoryBarrier.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryBarrier calloc(MemoryStack stack) {
        return (VkMemoryBarrier)VkMemoryBarrier.wrap(VkMemoryBarrier.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryBarrier.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryBarrier.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nsrcAccessMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCACCESSMASK);
    }

    public static int ndstAccessMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTACCESSMASK);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcAccessMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCACCESSMASK, value);
    }

    public static void ndstAccessMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTACCESSMASK, value);
    }

    static {
        Struct.Layout layout = VkMemoryBarrier.__struct((Struct.Member[])new Struct.Member[]{VkMemoryBarrier.__member((int)4), VkMemoryBarrier.__member((int)POINTER_SIZE), VkMemoryBarrier.__member((int)4), VkMemoryBarrier.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCACCESSMASK = layout.offsetof(2);
        DSTACCESSMASK = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryBarrier, Buffer>
    implements NativeResource {
        private static final VkMemoryBarrier ELEMENT_FACTORY = VkMemoryBarrier.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryBarrier getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryBarrier.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryBarrier.npNext(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int srcAccessMask() {
            return VkMemoryBarrier.nsrcAccessMask(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int dstAccessMask() {
            return VkMemoryBarrier.ndstAccessMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryBarrier.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(46);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryBarrier.npNext(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkMemoryBarrier.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkMemoryBarrier.ndstAccessMask(this.address(), value);
            return this;
        }
    }
}

