/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferDeviceAddressCreateInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEADDRESS;

    public VkBufferDeviceAddressCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBufferDeviceAddressCreateInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferDeviceAddressCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferDeviceAddressCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDeviceAddress")
    public long deviceAddress() {
        return VkBufferDeviceAddressCreateInfoEXT.ndeviceAddress(this.address());
    }

    public VkBufferDeviceAddressCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkBufferDeviceAddressCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkBufferDeviceAddressCreateInfoEXT sType$Default() {
        return this.sType(1000244002);
    }

    public VkBufferDeviceAddressCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkBufferDeviceAddressCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkBufferDeviceAddressCreateInfoEXT deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkBufferDeviceAddressCreateInfoEXT.ndeviceAddress(this.address(), value);
        return this;
    }

    public VkBufferDeviceAddressCreateInfoEXT set(int sType, long pNext, long deviceAddress) {
        this.sType(sType);
        this.pNext(pNext);
        this.deviceAddress(deviceAddress);
        return this;
    }

    public VkBufferDeviceAddressCreateInfoEXT set(VkBufferDeviceAddressCreateInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferDeviceAddressCreateInfoEXT malloc() {
        return (VkBufferDeviceAddressCreateInfoEXT)VkBufferDeviceAddressCreateInfoEXT.wrap(VkBufferDeviceAddressCreateInfoEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBufferDeviceAddressCreateInfoEXT calloc() {
        return (VkBufferDeviceAddressCreateInfoEXT)VkBufferDeviceAddressCreateInfoEXT.wrap(VkBufferDeviceAddressCreateInfoEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBufferDeviceAddressCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBufferDeviceAddressCreateInfoEXT)VkBufferDeviceAddressCreateInfoEXT.wrap(VkBufferDeviceAddressCreateInfoEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBufferDeviceAddressCreateInfoEXT create(long address) {
        return (VkBufferDeviceAddressCreateInfoEXT)VkBufferDeviceAddressCreateInfoEXT.wrap(VkBufferDeviceAddressCreateInfoEXT.class, (long)address);
    }

    @Nullable
    public static VkBufferDeviceAddressCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : (VkBufferDeviceAddressCreateInfoEXT)VkBufferDeviceAddressCreateInfoEXT.wrap(VkBufferDeviceAddressCreateInfoEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBufferDeviceAddressCreateInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBufferDeviceAddressCreateInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBufferDeviceAddressCreateInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferDeviceAddressCreateInfoEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBufferDeviceAddressCreateInfoEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBufferDeviceAddressCreateInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBufferDeviceAddressCreateInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkBufferDeviceAddressCreateInfoEXT mallocStack() {
        return VkBufferDeviceAddressCreateInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferDeviceAddressCreateInfoEXT callocStack() {
        return VkBufferDeviceAddressCreateInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferDeviceAddressCreateInfoEXT mallocStack(MemoryStack stack) {
        return VkBufferDeviceAddressCreateInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkBufferDeviceAddressCreateInfoEXT callocStack(MemoryStack stack) {
        return VkBufferDeviceAddressCreateInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBufferDeviceAddressCreateInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBufferDeviceAddressCreateInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferDeviceAddressCreateInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferDeviceAddressCreateInfoEXT.calloc(capacity, stack);
    }

    public static VkBufferDeviceAddressCreateInfoEXT malloc(MemoryStack stack) {
        return (VkBufferDeviceAddressCreateInfoEXT)VkBufferDeviceAddressCreateInfoEXT.wrap(VkBufferDeviceAddressCreateInfoEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferDeviceAddressCreateInfoEXT calloc(MemoryStack stack) {
        return (VkBufferDeviceAddressCreateInfoEXT)VkBufferDeviceAddressCreateInfoEXT.wrap(VkBufferDeviceAddressCreateInfoEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferDeviceAddressCreateInfoEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferDeviceAddressCreateInfoEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long ndeviceAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEADDRESS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndeviceAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DEVICEADDRESS, value);
    }

    static {
        Struct.Layout layout = VkBufferDeviceAddressCreateInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkBufferDeviceAddressCreateInfoEXT.__member((int)4), VkBufferDeviceAddressCreateInfoEXT.__member((int)POINTER_SIZE), VkBufferDeviceAddressCreateInfoEXT.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEADDRESS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBufferDeviceAddressCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkBufferDeviceAddressCreateInfoEXT ELEMENT_FACTORY = VkBufferDeviceAddressCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBufferDeviceAddressCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferDeviceAddressCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferDeviceAddressCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDeviceAddress")
        public long deviceAddress() {
            return VkBufferDeviceAddressCreateInfoEXT.ndeviceAddress(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferDeviceAddressCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000244002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferDeviceAddressCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer deviceAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkBufferDeviceAddressCreateInfoEXT.ndeviceAddress(this.address(), value);
            return this;
        }
    }
}

