/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureInstanceKHR;
import org.lwjgl.vulkan.VkAccelerationStructureMatrixMotionInstanceNV;
import org.lwjgl.vulkan.VkAccelerationStructureSRTMotionInstanceNV;

public class VkAccelerationStructureMotionInstanceDataNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STATICINSTANCE;
    public static final int MATRIXMOTIONINSTANCE;
    public static final int SRTMOTIONINSTANCE;

    public VkAccelerationStructureMotionInstanceDataNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAccelerationStructureMotionInstanceDataNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkAccelerationStructureInstanceKHR staticInstance() {
        return VkAccelerationStructureMotionInstanceDataNV.nstaticInstance(this.address());
    }

    public VkAccelerationStructureMatrixMotionInstanceNV matrixMotionInstance() {
        return VkAccelerationStructureMotionInstanceDataNV.nmatrixMotionInstance(this.address());
    }

    public VkAccelerationStructureSRTMotionInstanceNV srtMotionInstance() {
        return VkAccelerationStructureMotionInstanceDataNV.nsrtMotionInstance(this.address());
    }

    public VkAccelerationStructureMotionInstanceDataNV staticInstance(VkAccelerationStructureInstanceKHR value) {
        VkAccelerationStructureMotionInstanceDataNV.nstaticInstance(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV staticInstance(Consumer<VkAccelerationStructureInstanceKHR> consumer) {
        consumer.accept(this.staticInstance());
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV matrixMotionInstance(VkAccelerationStructureMatrixMotionInstanceNV value) {
        VkAccelerationStructureMotionInstanceDataNV.nmatrixMotionInstance(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV matrixMotionInstance(Consumer<VkAccelerationStructureMatrixMotionInstanceNV> consumer) {
        consumer.accept(this.matrixMotionInstance());
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV srtMotionInstance(VkAccelerationStructureSRTMotionInstanceNV value) {
        VkAccelerationStructureMotionInstanceDataNV.nsrtMotionInstance(this.address(), value);
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV srtMotionInstance(Consumer<VkAccelerationStructureSRTMotionInstanceNV> consumer) {
        consumer.accept(this.srtMotionInstance());
        return this;
    }

    public VkAccelerationStructureMotionInstanceDataNV set(VkAccelerationStructureMotionInstanceDataNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAccelerationStructureMotionInstanceDataNV malloc() {
        return (VkAccelerationStructureMotionInstanceDataNV)VkAccelerationStructureMotionInstanceDataNV.wrap(VkAccelerationStructureMotionInstanceDataNV.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkAccelerationStructureMotionInstanceDataNV calloc() {
        return (VkAccelerationStructureMotionInstanceDataNV)VkAccelerationStructureMotionInstanceDataNV.wrap(VkAccelerationStructureMotionInstanceDataNV.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkAccelerationStructureMotionInstanceDataNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkAccelerationStructureMotionInstanceDataNV)VkAccelerationStructureMotionInstanceDataNV.wrap(VkAccelerationStructureMotionInstanceDataNV.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkAccelerationStructureMotionInstanceDataNV create(long address) {
        return (VkAccelerationStructureMotionInstanceDataNV)VkAccelerationStructureMotionInstanceDataNV.wrap(VkAccelerationStructureMotionInstanceDataNV.class, (long)address);
    }

    @Nullable
    public static VkAccelerationStructureMotionInstanceDataNV createSafe(long address) {
        return address == 0L ? null : (VkAccelerationStructureMotionInstanceDataNV)VkAccelerationStructureMotionInstanceDataNV.wrap(VkAccelerationStructureMotionInstanceDataNV.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkAccelerationStructureMotionInstanceDataNV.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkAccelerationStructureMotionInstanceDataNV.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkAccelerationStructureMotionInstanceDataNV.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureMotionInstanceDataNV.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkAccelerationStructureMotionInstanceDataNV.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkAccelerationStructureMotionInstanceDataNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkAccelerationStructureMotionInstanceDataNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkAccelerationStructureMotionInstanceDataNV malloc(MemoryStack stack) {
        return (VkAccelerationStructureMotionInstanceDataNV)VkAccelerationStructureMotionInstanceDataNV.wrap(VkAccelerationStructureMotionInstanceDataNV.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureMotionInstanceDataNV calloc(MemoryStack stack) {
        return (VkAccelerationStructureMotionInstanceDataNV)VkAccelerationStructureMotionInstanceDataNV.wrap(VkAccelerationStructureMotionInstanceDataNV.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkAccelerationStructureMotionInstanceDataNV.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkAccelerationStructureMotionInstanceDataNV.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkAccelerationStructureInstanceKHR nstaticInstance(long struct) {
        return VkAccelerationStructureInstanceKHR.create(struct + (long)STATICINSTANCE);
    }

    public static VkAccelerationStructureMatrixMotionInstanceNV nmatrixMotionInstance(long struct) {
        return VkAccelerationStructureMatrixMotionInstanceNV.create(struct + (long)MATRIXMOTIONINSTANCE);
    }

    public static VkAccelerationStructureSRTMotionInstanceNV nsrtMotionInstance(long struct) {
        return VkAccelerationStructureSRTMotionInstanceNV.create(struct + (long)SRTMOTIONINSTANCE);
    }

    public static void nstaticInstance(long struct, VkAccelerationStructureInstanceKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)STATICINSTANCE), (long)VkAccelerationStructureInstanceKHR.SIZEOF);
    }

    public static void nmatrixMotionInstance(long struct, VkAccelerationStructureMatrixMotionInstanceNV value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MATRIXMOTIONINSTANCE), (long)VkAccelerationStructureMatrixMotionInstanceNV.SIZEOF);
    }

    public static void nsrtMotionInstance(long struct, VkAccelerationStructureSRTMotionInstanceNV value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SRTMOTIONINSTANCE), (long)VkAccelerationStructureSRTMotionInstanceNV.SIZEOF);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureMotionInstanceDataNV.__union((Struct.Member[])new Struct.Member[]{VkAccelerationStructureMotionInstanceDataNV.__member((int)VkAccelerationStructureInstanceKHR.SIZEOF, (int)VkAccelerationStructureInstanceKHR.ALIGNOF), VkAccelerationStructureMotionInstanceDataNV.__member((int)VkAccelerationStructureMatrixMotionInstanceNV.SIZEOF, (int)VkAccelerationStructureMatrixMotionInstanceNV.ALIGNOF), VkAccelerationStructureMotionInstanceDataNV.__member((int)VkAccelerationStructureSRTMotionInstanceNV.SIZEOF, (int)VkAccelerationStructureSRTMotionInstanceNV.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STATICINSTANCE = layout.offsetof(0);
        MATRIXMOTIONINSTANCE = layout.offsetof(1);
        SRTMOTIONINSTANCE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureMotionInstanceDataNV, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureMotionInstanceDataNV ELEMENT_FACTORY = VkAccelerationStructureMotionInstanceDataNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAccelerationStructureMotionInstanceDataNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkAccelerationStructureInstanceKHR staticInstance() {
            return VkAccelerationStructureMotionInstanceDataNV.nstaticInstance(this.address());
        }

        public VkAccelerationStructureMatrixMotionInstanceNV matrixMotionInstance() {
            return VkAccelerationStructureMotionInstanceDataNV.nmatrixMotionInstance(this.address());
        }

        public VkAccelerationStructureSRTMotionInstanceNV srtMotionInstance() {
            return VkAccelerationStructureMotionInstanceDataNV.nsrtMotionInstance(this.address());
        }

        public Buffer staticInstance(VkAccelerationStructureInstanceKHR value) {
            VkAccelerationStructureMotionInstanceDataNV.nstaticInstance(this.address(), value);
            return this;
        }

        public Buffer staticInstance(Consumer<VkAccelerationStructureInstanceKHR> consumer) {
            consumer.accept(this.staticInstance());
            return this;
        }

        public Buffer matrixMotionInstance(VkAccelerationStructureMatrixMotionInstanceNV value) {
            VkAccelerationStructureMotionInstanceDataNV.nmatrixMotionInstance(this.address(), value);
            return this;
        }

        public Buffer matrixMotionInstance(Consumer<VkAccelerationStructureMatrixMotionInstanceNV> consumer) {
            consumer.accept(this.matrixMotionInstance());
            return this;
        }

        public Buffer srtMotionInstance(VkAccelerationStructureSRTMotionInstanceNV value) {
            VkAccelerationStructureMotionInstanceDataNV.nsrtMotionInstance(this.address(), value);
            return this;
        }

        public Buffer srtMotionInstance(Consumer<VkAccelerationStructureSRTMotionInstanceNV> consumer) {
            consumer.accept(this.srtMotionInstance());
            return this;
        }
    }
}

