/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.graalvm.visualvm.lib.ui.UIUtils;

public class SmallButton
extends JButton {
    protected static final Icon NO_ICON = new Icon(){

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    };

    public SmallButton() {
        this(null, null);
    }

    public SmallButton(Icon icon) {
        this(null, icon);
    }

    public SmallButton(String text) {
        this(text, null);
    }

    public SmallButton(Action a) {
        super(a);
        this.setDefaultCapable(false);
        if (UIUtils.isWindowsLookAndFeel()) {
            this.setOpaque(false);
        }
    }

    public SmallButton(String text, Icon icon) {
        this.setDefaultCapable(false);
        if (UIUtils.isWindowsLookAndFeel()) {
            this.setOpaque(false);
        }
        this.setText(text);
        this.setIcon(icon);
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        boolean noIcon;
        boolean bl = noIcon = defaultIcon == null;
        if (defaultIcon == null) {
            defaultIcon = NO_ICON;
            this.setIconTextGap(0);
        }
        super.setIcon(defaultIcon);
        if (!noIcon) {
            this.putClientProperty("JComponent.sizeVariant", "regular");
        }
    }

    @Override
    public Insets getMargin() {
        Insets margin = super.getMargin();
        if (margin != null) {
            if (this.getParent() instanceof JToolBar) {
                if (UIUtils.isNimbus()) {
                    margin.left = margin.top + 3;
                    margin.right = margin.top + 3;
                }
            } else if (UIUtils.isNimbus()) {
                margin.left = margin.top - 6;
                margin.right = margin.top - 6;
            } else {
                margin.left = margin.top + 3;
                margin.right = margin.top + 3;
            }
        }
        return margin;
    }
}

