/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.commandInterface.commandLine;

import com.intellij.commandInterface.command.Command;
import com.intellij.commandInterface.command.Help;
import com.intellij.commandInterface.command.Option;
import com.intellij.commandInterface.commandLine.CommandLineElement;
import com.intellij.commandInterface.commandLine.CommandLinePart;
import com.intellij.commandInterface.commandLine.psi.CommandLineArgument;
import com.intellij.commandInterface.commandLine.psi.CommandLineCommand;
import com.intellij.commandInterface.commandLine.psi.CommandLineOption;
import com.intellij.commandInterface.commandLine.psi.CommandLineVisitor;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandLineDocumentationProvider
implements DocumentationProvider {
    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        Help help = CommandLineDocumentationProvider.findHelp(element);
        if (help == null) {
            return null;
        }
        String helpText = help.getHelpString();
        return StringUtil.isEmptyOrSpaces((String)helpText) ? null : helpText;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        Help help = CommandLineDocumentationProvider.findHelp(element);
        if (help == null) {
            return null;
        }
        String externalHelpUrl = help.getExternalHelpUrl();
        if (externalHelpUrl != null) {
            return Collections.singletonList(externalHelpUrl);
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor2, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor2 == null) {
            CommandLineDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CommandLineDocumentationProvider.$$$reportNull$$$0(1);
        }
        for (PsiElement element : Arrays.asList(contextElement, file.findElementAt(targetOffset - 1))) {
            CommandLineElement commandLineElement = (CommandLineElement)PsiTreeUtil.getParentOfType((PsiElement)element, CommandLineElement.class);
            if (commandLineElement == null) continue;
            return commandLineElement;
        }
        return null;
    }

    @Nullable
    private static Help findHelp(@NotNull PsiElement element) {
        if (element == null) {
            CommandLineDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (!(element instanceof CommandLinePart)) {
            return null;
        }
        CommandLinePart commandLinePart = (CommandLinePart)element;
        Command realCommand = commandLinePart.findRealCommand();
        if (realCommand == null) {
            return null;
        }
        CommandLineElement commandLineElement = (CommandLineElement)ObjectUtils.tryCast((Object)element, CommandLineElement.class);
        if (commandLineElement == null) {
            return null;
        }
        MyCommandHelpObtainer helpObtainer = new MyCommandHelpObtainer();
        commandLineElement.accept(helpObtainer);
        return helpObtainer.myResultHelp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/commandInterface/commandLine/CommandLineDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomDocumentationElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findHelp";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyCommandHelpObtainer
    extends CommandLineVisitor {
        private Help myResultHelp;

        private MyCommandHelpObtainer() {
        }

        @Override
        public void visitArgument(@NotNull CommandLineArgument o) {
            if (o == null) {
                MyCommandHelpObtainer.$$$reportNull$$$0(0);
            }
            super.visitArgument(o);
            this.myResultHelp = o.findBestHelp();
        }

        @Override
        public void visitCommand(@NotNull CommandLineCommand o) {
            if (o == null) {
                MyCommandHelpObtainer.$$$reportNull$$$0(1);
            }
            super.visitCommand(o);
            Command realCommand = o.findRealCommand();
            if (realCommand != null) {
                this.myResultHelp = realCommand.getHelp(false);
            }
        }

        @Override
        public void visitOption(@NotNull CommandLineOption o) {
            if (o == null) {
                MyCommandHelpObtainer.$$$reportNull$$$0(2);
            }
            super.visitOption(o);
            Option option = o.findRealOption();
            if (option == null) {
                return;
            }
            this.myResultHelp = option.getHelp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "o";
            objectArray2[1] = "com/intellij/commandInterface/commandLine/CommandLineDocumentationProvider$MyCommandHelpObtainer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArgument";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCommand";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOption";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

