/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.utils;

import java.lang.reflect.AccessibleObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public final class ReflectUtils {
    private static final Queue<PrivilegedProcessor> PROCESSORS_QUEUE = new ArrayBlockingQueue<PrivilegedProcessor>(32);

    private ReflectUtils() {
    }

    public static <T extends AccessibleObject> T makeAccessible(T obj) {
        if (obj != null && !obj.isAccessible()) {
            PrivilegedProcessor processor = PROCESSORS_QUEUE.poll();
            if (processor == null) {
                processor = new PrivilegedProcessor();
            }
            processor.setAccessibleObject(obj);
            AccessController.doPrivileged(processor);
            if (!PROCESSORS_QUEUE.offer(processor)) {
                throw new Error("Can't place processor into queue");
            }
        }
        return obj;
    }

    public static <T> T newInstance(Class<T> klazz) {
        try {
            return klazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new Error(String.format("Can't create instance of %s for error %s", klazz.getCanonicalName(), ex.getMessage()), ex);
        }
    }

    public static Object newInstanceForClassName(String className) {
        try {
            return ReflectUtils.newInstance(Class.forName(className));
        }
        catch (Exception ex) {
            throw new Error(String.format("Can't create instance of %s for error %s", className, ex.getMessage()), ex);
        }
    }

    private static final class PrivilegedProcessor
    implements PrivilegedAction<AccessibleObject> {
        private AccessibleObject theObject;

        private PrivilegedProcessor() {
        }

        public void setAccessibleObject(AccessibleObject obj) {
            this.theObject = obj;
        }

        @Override
        public AccessibleObject run() {
            AccessibleObject objectToProcess = this.theObject;
            this.theObject = null;
            if (objectToProcess != null) {
                objectToProcess.setAccessible(true);
            }
            return objectToProcess;
        }
    }
}

