/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.data.beans;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.swing.table.TableModel;
import org.jfree.report.DataSet;
import org.jfree.report.ReportData;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.TableReportData;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.DataSetUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class StaticReportDataFactory
implements ReportDataFactory {
    @Override
    public ReportData queryData(String string, DataSet dataSet) throws ReportDataFactoryException {
        int n = string.indexOf(35);
        if (n + 1 >= string.length()) {
            throw new ReportDataFactoryException("Malformed query: " + string);
        }
        if (n == -1) {
            String string2;
            String[] stringArray;
            int n2 = string.indexOf(40);
            if (n2 == -1) {
                stringArray = new String[]{};
                string2 = string;
            } else {
                stringArray = this.createParameterList(string, n2);
                string2 = string.substring(0, n2);
            }
            try {
                Constructor constructor = this.findDirectConstructor(string2, stringArray.length);
                Object[] objectArray = new Object[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    objectArray[i] = DataSetUtility.getByName(dataSet, string3);
                }
                Object t = constructor.newInstance(objectArray);
                if (t instanceof TableModel) {
                    return new TableReportData((TableModel)t);
                }
                return (ReportData)t;
            }
            catch (Exception exception) {
                throw new ReportDataFactoryException("Unable to instantiate class for non static call.", exception);
            }
        }
        return this.createComplexTableModel(string, n, dataSet);
    }

    private ReportData createComplexTableModel(String string, int n, DataSet dataSet) throws ReportDataFactoryException {
        String string2;
        String[] stringArray;
        String string3 = string.substring(0, n);
        int n2 = string3.indexOf(40);
        if (n2 == -1) {
            return this.loadFromDefaultConstructor(string, n, dataSet);
        }
        String string4 = string.substring(0, n2);
        String[] stringArray2 = this.createParameterList(string3, n2);
        Constructor constructor = this.findIndirectConstructor(string4, stringArray2.length);
        String string5 = string.substring(n + 1);
        int n3 = string5.indexOf(40);
        if (n3 == -1) {
            stringArray = new String[]{};
            string2 = string5;
        } else {
            string2 = string5.substring(0, n3);
            stringArray = this.createParameterList(string5, n3);
        }
        Method method = this.findCallableMethod(string4, string2, stringArray.length);
        try {
            Object[] objectArray;
            Object[] objectArray2 = new Object[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                objectArray = stringArray2[i];
                objectArray2[i] = DataSetUtility.getByName(dataSet, (String)objectArray);
            }
            Object t = constructor.newInstance(objectArray2);
            objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string6 = stringArray[i];
                objectArray[i] = DataSetUtility.getByName(dataSet, string6);
            }
            Object object = method.invoke(t, objectArray);
            if (object instanceof TableModel) {
                return new TableReportData((TableModel)object);
            }
            return (ReportData)object;
        }
        catch (Exception exception) {
            throw new ReportDataFactoryException("Unable to instantiate class for non static call.");
        }
    }

    private ReportData loadFromDefaultConstructor(String string, int n, DataSet dataSet) throws ReportDataFactoryException {
        String string2;
        String[] stringArray;
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        int n2 = string4.indexOf(40);
        if (n2 == -1) {
            stringArray = new String[]{};
            string2 = string4;
        } else {
            stringArray = this.createParameterList(string4, n2);
            string2 = string4.substring(0, n2);
        }
        try {
            Class<?> clazz;
            Method method = this.findCallableMethod(string3, string2, stringArray.length);
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                clazz = stringArray[i];
                objectArray[i] = DataSetUtility.getByName(dataSet, (String)((Object)clazz));
            }
            if (Modifier.isStatic(method.getModifiers())) {
                Object object = method.invoke(null, objectArray);
                if (object instanceof TableModel) {
                    return new TableReportData((TableModel)object);
                }
                return (ReportData)object;
            }
            ClassLoader classLoader = this.getClassLoader();
            clazz = classLoader.loadClass(string3);
            Object t = clazz.newInstance();
            if (t == null) {
                throw new ReportDataFactoryException("Unable to instantiate class for non static call.");
            }
            Object object = method.invoke(t, objectArray);
            if (object instanceof TableModel) {
                return new TableReportData((TableModel)object);
            }
            return (ReportData)object;
        }
        catch (ReportDataFactoryException reportDataFactoryException) {
            throw reportDataFactoryException;
        }
        catch (Exception exception) {
            throw new ReportDataFactoryException("Something went terribly wrong: ", exception);
        }
    }

    private String[] createParameterList(String string, int n) throws ReportDataFactoryException {
        int n2 = string.lastIndexOf(41);
        if (n2 < n) {
            throw new ReportDataFactoryException("Malformed query: " + string);
        }
        String string2 = string.substring(n + 1, n2);
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string2);
        int n3 = cSVTokenizer.countTokens();
        String[] stringArray = new String[n3];
        int n4 = 0;
        while (cSVTokenizer.hasMoreTokens()) {
            stringArray[n4] = cSVTokenizer.nextToken();
            ++n4;
        }
        return stringArray;
    }

    protected ClassLoader getClassLoader() {
        return ObjectUtilities.getClassLoader(StaticReportDataFactory.class);
    }

    private Method findCallableMethod(String string, String string2, int n) throws ReportDataFactoryException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new ReportDataFactoryException("No classloader!");
        }
        try {
            Class<?> clazz = classLoader.loadClass(string);
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new ReportDataFactoryException("Abstract class cannot be handled!");
            }
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(string2)) continue;
                Class<?> clazz2 = method.getReturnType();
                if (method.getParameterTypes().length != n || !TableModel.class.isAssignableFrom(clazz2) && !ReportData.class.isAssignableFrom(clazz2)) continue;
                return method;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReportDataFactoryException("No such Class", classNotFoundException);
        }
        throw new ReportDataFactoryException("No such Method: " + string + "#" + string2);
    }

    private Constructor findDirectConstructor(String string, int n) throws ReportDataFactoryException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new ReportDataFactoryException("No classloader!");
        }
        try {
            Class<?> clazz = classLoader.loadClass(string);
            if (!TableModel.class.isAssignableFrom(clazz) && !ReportData.class.isAssignableFrom(clazz)) {
                throw new ReportDataFactoryException("The specified class must be either a TableModel or a ReportData implementation.");
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new ReportDataFactoryException("The specified class cannot be instantiated: it is abstract.");
            }
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Constructor<?> constructor = constructorArray[i];
                if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != n) continue;
                return constructor;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReportDataFactoryException("No such Class", classNotFoundException);
        }
        throw new ReportDataFactoryException("There is no constructor in class " + string + " that accepts " + n + " parameters.");
    }

    private Constructor findIndirectConstructor(String string, int n) throws ReportDataFactoryException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new ReportDataFactoryException("No classloader!");
        }
        try {
            Class<?> clazz = classLoader.loadClass(string);
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new ReportDataFactoryException("The specified class cannot be instantiated: it is abstract.");
            }
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Constructor<?> constructor = constructorArray[i];
                if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != n) continue;
                return constructor;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReportDataFactoryException("No such Class", classNotFoundException);
        }
        throw new ReportDataFactoryException("There is no constructor in class " + string + " that accepts " + n + " parameters.");
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public ReportDataFactory derive() {
        return this;
    }
}

