/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.converter.Converter;
import org.aesh.command.impl.activator.NullActivator;
import org.aesh.command.impl.completer.BooleanOptionCompleter;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.completer.NullOptionCompleter;
import org.aesh.command.impl.converter.NullConverter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.AeshOptionParser;
import org.aesh.command.impl.renderer.NullOptionRenderer;
import org.aesh.command.impl.validator.NullValidator;
import org.aesh.command.parser.OptionParser;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.renderer.OptionRenderer;
import org.aesh.command.validator.OptionValidator;
import org.aesh.converter.CLConverterManager;
import org.aesh.io.Resource;
import org.aesh.util.ReflectionUtil;

public class ProcessedOptionBuilder {
    private char shortName;
    private String name;
    private String description;
    private String argument;
    private Class<?> type;
    private boolean hasValue = true;
    private boolean required = false;
    private boolean isProperty = false;
    private boolean hasMultipleValues = false;
    private char valueSeparator = (char)32;
    private OptionType optionType;
    private Converter converter;
    private String fieldName;
    private OptionCompleter completer;
    private final List<String> defaultValues = new ArrayList<String>();
    private OptionValidator validator;
    private OptionActivator activator;
    private OptionRenderer renderer;
    private boolean overrideRequired;
    private OptionParser parser;
    private boolean askIfNotSet = false;

    private ProcessedOptionBuilder() {
    }

    public static ProcessedOptionBuilder builder() {
        return new ProcessedOptionBuilder();
    }

    private ProcessedOptionBuilder apply(Consumer<ProcessedOptionBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public ProcessedOptionBuilder shortName(char n) {
        return this.apply(c -> {
            c.shortName = n;
        });
    }

    public ProcessedOptionBuilder name(String name) {
        return this.apply(c -> {
            c.name = name;
        });
    }

    public ProcessedOptionBuilder description(String description) {
        return this.apply(c -> {
            c.description = description;
        });
    }

    public ProcessedOptionBuilder argument(String argument) {
        return this.apply(c -> {
            c.argument = argument;
        });
    }

    public ProcessedOptionBuilder type(Class<?> type) {
        return this.apply(c -> {
            c.type = type;
        });
    }

    public ProcessedOptionBuilder required(boolean required) {
        return this.apply(c -> {
            c.required = required;
        });
    }

    public ProcessedOptionBuilder askIfNotSet(boolean askIfNotSet) {
        return this.apply(c -> {
            c.askIfNotSet = askIfNotSet;
        });
    }

    public ProcessedOptionBuilder fieldName(String fieldName) {
        return this.apply(c -> {
            c.fieldName = fieldName;
        });
    }

    public ProcessedOptionBuilder hasValue(boolean hasValue) {
        return this.apply(c -> {
            c.hasValue = hasValue;
        });
    }

    public ProcessedOptionBuilder isProperty(boolean isProperty) {
        return this.apply(c -> {
            c.isProperty = isProperty;
        });
    }

    public ProcessedOptionBuilder hasMultipleValues(boolean multipleValues) {
        return this.apply(c -> {
            c.hasMultipleValues = multipleValues;
        });
    }

    public ProcessedOptionBuilder addDefaultValue(String defaultValue) {
        return this.apply(c -> c.defaultValues.add(defaultValue));
    }

    public ProcessedOptionBuilder addAllDefaultValues(List<String> defaultValues) {
        return this.apply(c -> c.defaultValues.addAll(defaultValues));
    }

    public ProcessedOptionBuilder addAllDefaultValues(String[] defaultValues) {
        return this.apply(c -> c.defaultValues.addAll(Arrays.asList(defaultValues)));
    }

    public ProcessedOptionBuilder valueSeparator(char valueSeparator) {
        return this.apply(c -> {
            c.valueSeparator = valueSeparator;
        });
    }

    public ProcessedOptionBuilder optionType(OptionType optionType) {
        return this.apply(c -> {
            c.optionType = optionType;
        });
    }

    public ProcessedOptionBuilder converter(Converter converter) {
        return this.apply(c -> {
            c.converter = converter;
        });
    }

    public ProcessedOptionBuilder converter(Class<? extends Converter> converter) {
        return this.apply(c -> {
            c.converter = this.initConverter(converter);
        });
    }

    private Converter initConverter(Class<? extends Converter> converterClass) {
        if (converterClass != null && !converterClass.equals(NullConverter.class)) {
            if (CLConverterManager.getInstance().hasConverter(converterClass)) {
                return CLConverterManager.getInstance().getConverter(converterClass);
            }
            return ReflectionUtil.newInstance(converterClass);
        }
        return CLConverterManager.getInstance().getConverter(this.type);
    }

    public ProcessedOptionBuilder completer(OptionCompleter completer) {
        return this.apply(c -> {
            c.completer = completer;
        });
    }

    public ProcessedOptionBuilder completer(Class<? extends OptionCompleter> completer) {
        return this.apply(c -> {
            c.completer = this.initCompleter(completer);
        });
    }

    private OptionCompleter initCompleter(Class<? extends OptionCompleter> completerClass) {
        if (completerClass != null && !completerClass.equals(NullOptionCompleter.class)) {
            return ReflectionUtil.newInstance(completerClass);
        }
        try {
            if (this.type == Boolean.class || this.type == Boolean.TYPE) {
                return (OptionCompleter)BooleanOptionCompleter.class.newInstance();
            }
            if (this.type == File.class || this.type == Resource.class) {
                return (OptionCompleter)FileOptionCompleter.class.newInstance();
            }
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ProcessedOptionBuilder validator(OptionValidator validator) {
        return this.apply(c -> {
            c.validator = validator;
        });
    }

    public ProcessedOptionBuilder validator(Class<? extends OptionValidator> validator) {
        return this.apply(c -> {
            c.validator = this.initValidator(validator);
        });
    }

    private OptionValidator initValidator(Class<? extends OptionValidator> validator) {
        if (validator != null && validator != NullValidator.class) {
            return ReflectionUtil.newInstance(validator);
        }
        return new NullValidator();
    }

    public ProcessedOptionBuilder activator(OptionActivator activator) {
        return this.apply(c -> {
            c.activator = activator;
        });
    }

    public ProcessedOptionBuilder activator(Class<? extends OptionActivator> activator) {
        return this.apply(c -> {
            c.activator = this.initActivator(activator);
        });
    }

    private OptionActivator initActivator(Class<? extends OptionActivator> activator) {
        if (activator != null && activator != NullActivator.class) {
            return ReflectionUtil.newInstance(activator);
        }
        return new NullActivator();
    }

    public ProcessedOptionBuilder renderer(OptionRenderer renderer) {
        return this.apply(c -> {
            c.renderer = renderer;
        });
    }

    public ProcessedOptionBuilder renderer(Class<? extends OptionRenderer> renderer) {
        return this.apply(c -> {
            c.renderer = this.initRenderer(renderer);
        });
    }

    private OptionRenderer initRenderer(Class<? extends OptionRenderer> renderer) {
        if (renderer != null && renderer != NullOptionRenderer.class) {
            return ReflectionUtil.newInstance(renderer);
        }
        return null;
    }

    public ProcessedOptionBuilder overrideRequired(boolean overrideRequired) {
        return this.apply(c -> {
            c.overrideRequired = overrideRequired;
        });
    }

    public ProcessedOptionBuilder parser(OptionParser parser) {
        return this.apply(c -> {
            c.parser = parser;
        });
    }

    public ProcessedOptionBuilder parser(Class<? extends OptionParser> parser) {
        return this.apply(c -> {
            c.parser = this.initParser(parser);
        });
    }

    private OptionParser initParser(Class<? extends OptionParser> parser) {
        if (parser != null) {
            return ReflectionUtil.newInstance(parser);
        }
        return null;
    }

    public ProcessedOption build() throws OptionParserException {
        if (this.optionType == null) {
            this.optionType = !this.hasValue ? OptionType.BOOLEAN : (this.isProperty ? OptionType.GROUP : (this.hasMultipleValues ? OptionType.LIST : OptionType.NORMAL));
        }
        if ((this.name == null || this.name.length() < 1) && this.optionType != OptionType.ARGUMENTS && this.optionType != OptionType.ARGUMENT) {
            if (this.fieldName == null || this.fieldName.length() < 1) {
                throw new OptionParserException("Name must be defined to build an Option");
            }
            this.name = this.fieldName;
        }
        if (this.fieldName == null) {
            this.fieldName = this.name;
        }
        if (this.type == null) {
            throw new OptionParserException("Type must be defined to build an Option");
        }
        if (this.shortName == '\u0000' && "".equals(this.name) && this.optionType != OptionType.ARGUMENTS && this.optionType != OptionType.ARGUMENT) {
            throw new OptionParserException("Either shortName or name must be set.");
        }
        if (this.validator == null) {
            this.validator = new NullValidator();
        }
        if (this.converter == null) {
            this.converter = CLConverterManager.getInstance().getConverter(this.type);
        }
        if (this.activator == null) {
            this.activator = new NullActivator();
        }
        if (this.parser == null) {
            this.parser = new AeshOptionParser();
        }
        return new ProcessedOption(this.shortName, this.name, this.description, this.argument, this.required, this.valueSeparator, this.askIfNotSet, this.defaultValues, this.type, this.fieldName, this.optionType, this.converter, this.completer, this.validator, this.activator, this.renderer, this.parser, this.overrideRequired);
    }
}

