/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.io.file.PathUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.backup.repository.AbstractBackupRepository;
import org.apache.solr.core.backup.repository.BackupRepository;

public class LocalFileSystemRepository
extends AbstractBackupRepository {
    @Override
    public <T> T getConfigProperty(String name) {
        return (T)this.config.get(name);
    }

    @Override
    public URI createURI(String location) {
        Objects.requireNonNull(location);
        URI result = null;
        try {
            result = new URI(location);
            if (!result.isAbsolute()) {
                result = Path.of(location, new String[0]).toUri();
            }
        }
        catch (URISyntaxException ex) {
            result = Path.of(location, new String[0]).toUri();
        }
        return result;
    }

    @Override
    public URI resolve(URI baseUri, String ... pathComponents) {
        if (pathComponents.length <= 0) {
            throw new IllegalArgumentException("pathComponents.length must be greater than 0.");
        }
        Path result = Path.of(baseUri);
        for (String pathComponent : pathComponents) {
            try {
                result = result.resolve(pathComponent);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result.toUri();
    }

    @Override
    public void createDirectory(URI path) throws IOException {
        Path p = Path.of(path);
        if (!Files.exists(p, LinkOption.NOFOLLOW_LINKS)) {
            Files.createDirectories(p, new FileAttribute[0]);
        }
    }

    @Override
    public void deleteDirectory(URI path) throws IOException {
        PathUtils.deleteDirectory((Path)Path.of(path));
    }

    @Override
    public boolean exists(URI path) throws IOException {
        return Files.exists(Path.of(path), new LinkOption[0]);
    }

    @Override
    public IndexInput openInput(URI dirPath, String fileName, IOContext ctx) throws IOException {
        try (NIOFSDirectory dir = new NIOFSDirectory(Path.of(dirPath), (LockFactory)NoLockFactory.INSTANCE);){
            IndexInput indexInput = dir.openInput(fileName, ctx);
            return indexInput;
        }
    }

    @Override
    public OutputStream createOutput(URI path) throws IOException {
        return Files.newOutputStream(Path.of(path), new OpenOption[0]);
    }

    @Override
    public String[] listAll(URI dirPath) throws IOException {
        if (!this.exists(dirPath)) {
            return new String[0];
        }
        try (NIOFSDirectory dir = new NIOFSDirectory(Path.of(dirPath), (LockFactory)NoLockFactory.INSTANCE);){
            String[] stringArray = dir.listAll();
            return stringArray;
        }
    }

    @Override
    public BackupRepository.PathType getPathType(URI path) throws IOException {
        return Files.isDirectory(Path.of(path), new LinkOption[0]) ? BackupRepository.PathType.DIRECTORY : BackupRepository.PathType.FILE;
    }

    @Override
    public void copyIndexFileFrom(Directory sourceDir, String sourceFileName, URI destDir, String destFileName) throws IOException {
        try (NIOFSDirectory dir = new NIOFSDirectory(Path.of(destDir), (LockFactory)NoLockFactory.INSTANCE);){
            this.copyIndexFileFrom(sourceDir, sourceFileName, (Directory)dir, destFileName);
        }
    }

    @Override
    public void copyIndexFileTo(URI sourceDir, String sourceFileName, Directory dest, String destFileName) throws IOException {
        try (NIOFSDirectory dir = new NIOFSDirectory(Path.of(sourceDir), (LockFactory)NoLockFactory.INSTANCE);){
            dest.copyFrom((Directory)dir, sourceFileName, destFileName, DirectoryFactory.IOCONTEXT_NO_CACHE);
        }
    }

    @Override
    public void delete(URI path, Collection<String> files) throws IOException {
        if (files.isEmpty()) {
            return;
        }
        try (NIOFSDirectory dir = new NIOFSDirectory(Path.of(path), (LockFactory)NoLockFactory.INSTANCE);){
            for (String file : files) {
                try {
                    dir.deleteFile(file);
                }
                catch (NoSuchFileException noSuchFileException) {}
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

