/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.Shard;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.DeleteCollectionRequest;
import org.apache.solr.cluster.placement.DeleteReplicasRequest;
import org.apache.solr.cluster.placement.DeleteShardsRequest;
import org.apache.solr.cluster.placement.impl.SimpleClusterAbstractionsImpl;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Slice;

public class ModificationRequestImpl {
    public static DeleteCollectionRequest createDeleteCollectionRequest(DocCollection docCollection) {
        SolrCollection solrCollection = SimpleClusterAbstractionsImpl.SolrCollectionImpl.fromDocCollection(docCollection);
        return () -> solrCollection;
    }

    public static DeleteReplicasRequest createDeleteReplicasRequest(final SolrCollection collection, final Set<Replica> replicas) {
        return new DeleteReplicasRequest(){

            @Override
            public Set<Replica> getReplicas() {
                return replicas;
            }

            @Override
            public SolrCollection getCollection() {
                return collection;
            }

            public String toString() {
                return "DeleteReplicasRequest{collection=" + collection.getName() + ",replicas=" + replicas;
            }
        };
    }

    public static DeleteReplicasRequest createDeleteReplicasRequest(DocCollection docCollection, String shardName, Set<org.apache.solr.common.cloud.Replica> replicas) {
        SolrCollection solrCollection = SimpleClusterAbstractionsImpl.SolrCollectionImpl.fromDocCollection(docCollection);
        Shard shard = solrCollection.getShard(shardName);
        Slice slice = docCollection.getSlice(shardName);
        HashSet<Replica> solrReplicas = new HashSet<Replica>();
        replicas.forEach(replica -> solrReplicas.add(shard.getReplica(replica.getName())));
        return ModificationRequestImpl.createDeleteReplicasRequest(solrCollection, solrReplicas);
    }

    public static DeleteShardsRequest createDeleteShardsRequest(final SolrCollection collection, final Set<String> shardNames) {
        return new DeleteShardsRequest(){

            @Override
            public Set<String> getShardNames() {
                return shardNames;
            }

            @Override
            public SolrCollection getCollection() {
                return collection;
            }

            public String toString() {
                return "DeleteShardsRequest{collection=" + collection.getName() + ",shards=" + shardNames;
            }
        };
    }

    public static DeleteShardsRequest createDeleteShardsRequest(DocCollection docCollection, Set<String> shardNames) {
        SolrCollection solrCollection = SimpleClusterAbstractionsImpl.SolrCollectionImpl.fromDocCollection(docCollection);
        return ModificationRequestImpl.createDeleteShardsRequest(solrCollection, shardNames);
    }
}

