/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.sentiment.analysis;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import opennlp.tools.sentiment.SentimentME;
import opennlp.tools.sentiment.SentimentModel;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SentimentParser
extends AbstractParser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"sentiment"));
    public static final String HELLO_MIME_TYPE = "application/sentiment";
    private static final Logger LOG = Logger.getLogger(SentimentParser.class.getName());
    private SentimentME sentiment;
    private URL modelUrl;
    private File modelFile;
    private boolean initialised;
    private boolean available;

    public SentimentParser() {
        System.out.println("Create sentiment parser");
    }

    public void initialise(URL url) {
        try {
            if (this.modelUrl != null && this.modelUrl.toURI().equals(this.modelUrl.toURI())) {
                return;
            }
        }
        catch (URISyntaxException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        this.modelUrl = url;
        boolean bl = this.available = url != null;
        if (this.available) {
            try {
                SentimentModel model = new SentimentModel(url);
                this.sentiment = new SentimentME(model);
            }
            catch (Exception e) {
                LOG.warning("Sentiment Parser setup failed: " + e);
                this.available = false;
            }
        }
        this.initialised = true;
    }

    public void initialise(File file) {
        this.modelFile = file;
        try {
            SentimentModel model = new SentimentModel(file);
            this.sentiment = new SentimentME(model);
            this.available = true;
        }
        catch (IOException e) {
            LOG.warning("Sentiment Parser setup failed: " + e);
            this.available = false;
        }
        this.initialised = true;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!this.initialised) {
            String model = metadata.get("model");
            this.initialise(new File(model));
        }
        if (this.available) {
            String inputString = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            String output = this.sentiment.predict(inputString);
            metadata.add("Sentiment: ", output);
        } else {
            metadata.add("Error", "Model is not available");
        }
    }
}

