/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.ConfigSetAdminResponse;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;

public class MirroredSolrRequest<T extends SolrResponse> {
    private final SolrRequest<T> solrRequest;
    private final Type type;
    private int attempt = 1;
    private long submitTimeNanos = 0L;

    public MirroredSolrRequest(SolrRequest<T> solrRequest) {
        this(Type.UPDATE, 1, solrRequest, System.nanoTime());
    }

    public MirroredSolrRequest(Type type, SolrRequest<T> solrRequest) {
        this(type, 1, solrRequest);
    }

    public MirroredSolrRequest(Type type, int attempt, SolrRequest<T> solrRequest) {
        this(type, attempt, solrRequest, System.nanoTime());
    }

    public MirroredSolrRequest(Type type, int attempt, SolrRequest<T> solrRequest, long submitTimeNanos) {
        if (solrRequest == null) {
            throw new NullPointerException("solrRequest cannot be null");
        }
        this.type = type;
        this.attempt = attempt;
        this.solrRequest = solrRequest;
        this.submitTimeNanos = submitTimeNanos;
    }

    public MirroredSolrRequest(int attempt, long submitTimeNanos) {
        this.type = Type.UPDATE;
        this.attempt = attempt;
        this.submitTimeNanos = submitTimeNanos;
        this.solrRequest = null;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    public SolrRequest<T> getSolrRequest() {
        return this.solrRequest;
    }

    public long getSubmitTimeNanos() {
        return this.submitTimeNanos;
    }

    public void setSubmitTimeNanos(long submitTimeNanos) {
        this.submitTimeNanos = submitTimeNanos;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MirroredSolrRequest)) {
            return false;
        }
        MirroredSolrRequest that = (MirroredSolrRequest)o;
        return Objects.equals(this.solrRequest, that.solrRequest);
    }

    public static void setParams(SolrRequest<?> request, ModifiableSolrParams params) {
        if (request instanceof MirroredAdminRequest) {
            ((MirroredAdminRequest)request).setParams(params);
        } else if (request instanceof UpdateRequest) {
            ((UpdateRequest)request).setParams(params);
        } else {
            throw new UnsupportedOperationException("Can't setParams on request " + request);
        }
    }

    public int hashCode() {
        return this.solrRequest.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{type=");
        sb.append(this.type.toString());
        sb.append(", method=" + this.solrRequest.getMethod());
        sb.append(", params=" + this.solrRequest.getParams());
        if (this.solrRequest instanceof UpdateRequest) {
            UpdateRequest req = (UpdateRequest)this.solrRequest;
            sb.append(", add=" + (Serializable)(req.getDocuments() != null ? Integer.valueOf(req.getDocuments().size()) : "0"));
            sb.append(", del=" + (Serializable)(req.getDeleteByIdMap() != null ? Integer.valueOf(req.getDeleteByIdMap().size()) : "0"));
            sb.append(", dbq=" + (Serializable)(req.getDeleteQuery() != null ? Integer.valueOf(req.getDeleteQuery().size()) : "0"));
        }
        sb.append(", attempt=" + this.attempt);
        sb.append(", submitTimeNanos=" + this.submitTimeNanos);
        sb.append('}');
        return sb.toString();
    }

    public static class ExposedByteArrayContentStream
    extends ContentStreamBase {
        private final byte[] bytes;

        public ExposedByteArrayContentStream(byte[] bytes, String source, String contentType) {
            this.bytes = bytes;
            this.contentType = contentType;
            this.name = source;
            this.size = bytes.length;
            this.sourceInfo = source;
        }

        public byte[] byteArray() {
            return this.bytes;
        }

        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }

        public String toString() {
            return "contentType=" + this.contentType + ", name=" + this.name + ", sourceInfo=" + this.sourceInfo + ", size=" + this.size;
        }

        public static ExposedByteArrayContentStream of(ContentStream cs) throws IOException {
            if (cs instanceof ExposedByteArrayContentStream) {
                return (ExposedByteArrayContentStream)cs;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            cs.getStream().transferTo(baos);
            ExposedByteArrayContentStream res = new ExposedByteArrayContentStream(baos.toByteArray(), cs.getSourceInfo(), cs.getContentType());
            res.setName(cs.getName());
            return res;
        }
    }

    public static class MirroredConfigSetRequest
    extends ConfigSetAdminRequest<MirroredConfigSetRequest, ConfigSetAdminResponse> {
        private Collection<ContentStream> contentStreams;
        private ModifiableSolrParams params;

        public MirroredConfigSetRequest(SolrRequest.METHOD method, SolrParams params, Collection<ContentStream> contentStreams) {
            this.setMethod(method);
            this.params = ModifiableSolrParams.of((SolrParams)params);
            this.contentStreams = contentStreams;
            if (method == SolrRequest.METHOD.POST && (contentStreams == null || contentStreams.isEmpty())) {
                throw new RuntimeException("Invalid request - POST requires at least 1 content stream");
            }
        }

        protected MirroredConfigSetRequest getThis() {
            return this;
        }

        public SolrParams getParams() {
            return this.params;
        }

        public void setParams(ModifiableSolrParams params) {
            this.params = params;
        }

        public Collection<ContentStream> getContentStreams() {
            return this.contentStreams;
        }

        protected ConfigSetAdminResponse createResponse(SolrClient client) {
            return new ConfigSetAdminResponse();
        }
    }

    public static class MirroredAdminRequest
    extends CollectionAdminRequest<CollectionAdminResponse> {
        private ModifiableSolrParams params;

        public MirroredAdminRequest(CollectionParams.CollectionAction action, ModifiableSolrParams params) {
            super(action);
            this.params = params;
        }

        public SolrParams getParams() {
            return this.params;
        }

        public void setParams(ModifiableSolrParams params) {
            this.params = params;
        }

        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }
    }

    public static enum Type {
        UPDATE,
        ADMIN,
        CONFIGSET,
        UNKNOWN;


        public static final Type get(String s) {
            if (s == null) {
                return UNKNOWN;
            }
            return Type.valueOf(s.toUpperCase(Locale.ROOT));
        }
    }
}

