/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.common;

import java.util.Map;

public class ConfigProperty {
    private final String key;
    private final String defaultValue;
    private boolean required = false;

    public ConfigProperty(String key, String defaultValue, boolean required) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.required = required;
    }

    public ConfigProperty(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public ConfigProperty(String key) {
        this.key = key;
        this.defaultValue = null;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getValue(Map<?, ?> properties) {
        String val = (String)properties.get(this.key);
        if (val == null) {
            return this.defaultValue;
        }
        return val;
    }

    public Integer getValueAsInt(Map<?, ?> properties) {
        Object value = properties.get(this.key);
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return Integer.parseInt(value.toString());
        }
        if (this.defaultValue == null) {
            return null;
        }
        return Integer.parseInt(this.defaultValue);
    }

    public Boolean getValueAsBoolean(Map<?, ?> properties) {
        Object value = properties.get(this.key);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.parseBoolean(value.toString());
        }
        return Boolean.parseBoolean(this.defaultValue);
    }
}

