/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene90;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.codecs.CompetitiveImpactAccumulator;
import org.apache.lucene.codecs.MultiLevelSkipListWriter;
import org.apache.lucene.index.Impact;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;

final class Lucene90SkipWriter
extends MultiLevelSkipListWriter {
    private int[] lastSkipDoc;
    private long[] lastSkipDocPointer;
    private long[] lastSkipPosPointer;
    private long[] lastSkipPayPointer;
    private int[] lastPayloadByteUpto;
    private final IndexOutput docOut;
    private final IndexOutput posOut;
    private final IndexOutput payOut;
    private int curDoc;
    private long curDocPointer;
    private long curPosPointer;
    private long curPayPointer;
    private int curPosBufferUpto;
    private int curPayloadByteUpto;
    private CompetitiveImpactAccumulator[] curCompetitiveFreqNorms;
    private boolean fieldHasPositions;
    private boolean fieldHasOffsets;
    private boolean fieldHasPayloads;
    private boolean initialized;
    long lastDocFP;
    long lastPosFP;
    long lastPayFP;
    private final ByteBuffersDataOutput freqNormOut = ByteBuffersDataOutput.newResettableInstance();

    public Lucene90SkipWriter(int maxSkipLevels, int blockSize, int docCount, IndexOutput docOut, IndexOutput posOut, IndexOutput payOut) {
        super(blockSize, 8, maxSkipLevels, docCount);
        this.docOut = docOut;
        this.posOut = posOut;
        this.payOut = payOut;
        this.lastSkipDoc = new int[maxSkipLevels];
        this.lastSkipDocPointer = new long[maxSkipLevels];
        if (posOut != null) {
            this.lastSkipPosPointer = new long[maxSkipLevels];
            if (payOut != null) {
                this.lastSkipPayPointer = new long[maxSkipLevels];
            }
            this.lastPayloadByteUpto = new int[maxSkipLevels];
        }
        this.curCompetitiveFreqNorms = new CompetitiveImpactAccumulator[maxSkipLevels];
        for (int i = 0; i < maxSkipLevels; ++i) {
            this.curCompetitiveFreqNorms[i] = new CompetitiveImpactAccumulator();
        }
    }

    void setField(boolean fieldHasPositions, boolean fieldHasOffsets, boolean fieldHasPayloads) {
        this.fieldHasPositions = fieldHasPositions;
        this.fieldHasOffsets = fieldHasOffsets;
        this.fieldHasPayloads = fieldHasPayloads;
    }

    public void resetSkip() {
        this.lastDocFP = this.docOut.getFilePointer();
        if (this.fieldHasPositions) {
            this.lastPosFP = this.posOut.getFilePointer();
            if (this.fieldHasOffsets || this.fieldHasPayloads) {
                this.lastPayFP = this.payOut.getFilePointer();
            }
        }
        if (this.initialized) {
            for (CompetitiveImpactAccumulator acc : this.curCompetitiveFreqNorms) {
                acc.clear();
            }
        }
        this.initialized = false;
    }

    private void initSkip() {
        if (!this.initialized) {
            super.resetSkip();
            Arrays.fill(this.lastSkipDoc, 0);
            Arrays.fill(this.lastSkipDocPointer, this.lastDocFP);
            if (this.fieldHasPositions) {
                Arrays.fill(this.lastSkipPosPointer, this.lastPosFP);
                if (this.fieldHasPayloads) {
                    Arrays.fill(this.lastPayloadByteUpto, 0);
                }
                if (this.fieldHasOffsets || this.fieldHasPayloads) {
                    Arrays.fill(this.lastSkipPayPointer, this.lastPayFP);
                }
            }
            assert (Arrays.stream(this.curCompetitiveFreqNorms).map(CompetitiveImpactAccumulator::getCompetitiveFreqNormPairs).mapToInt(Collection::size).sum() == 0);
            this.initialized = true;
        }
    }

    public void bufferSkip(int doc, CompetitiveImpactAccumulator competitiveFreqNorms, int numDocs, long posFP, long payFP, int posBufferUpto, int payloadByteUpto) throws IOException {
        this.initSkip();
        this.curDoc = doc;
        this.curDocPointer = this.docOut.getFilePointer();
        this.curPosPointer = posFP;
        this.curPayPointer = payFP;
        this.curPosBufferUpto = posBufferUpto;
        this.curPayloadByteUpto = payloadByteUpto;
        this.curCompetitiveFreqNorms[0].addAll(competitiveFreqNorms);
        this.bufferSkip(numDocs);
    }

    protected void writeSkipData(int level, DataOutput skipBuffer) throws IOException {
        int delta = this.curDoc - this.lastSkipDoc[level];
        skipBuffer.writeVInt(delta);
        this.lastSkipDoc[level] = this.curDoc;
        skipBuffer.writeVLong(this.curDocPointer - this.lastSkipDocPointer[level]);
        this.lastSkipDocPointer[level] = this.curDocPointer;
        if (this.fieldHasPositions) {
            skipBuffer.writeVLong(this.curPosPointer - this.lastSkipPosPointer[level]);
            this.lastSkipPosPointer[level] = this.curPosPointer;
            skipBuffer.writeVInt(this.curPosBufferUpto);
            if (this.fieldHasPayloads) {
                skipBuffer.writeVInt(this.curPayloadByteUpto);
            }
            if (this.fieldHasOffsets || this.fieldHasPayloads) {
                skipBuffer.writeVLong(this.curPayPointer - this.lastSkipPayPointer[level]);
                this.lastSkipPayPointer[level] = this.curPayPointer;
            }
        }
        CompetitiveImpactAccumulator competitiveFreqNorms = this.curCompetitiveFreqNorms[level];
        assert (competitiveFreqNorms.getCompetitiveFreqNormPairs().size() > 0);
        if (level + 1 < this.numberOfSkipLevels) {
            this.curCompetitiveFreqNorms[level + 1].addAll(competitiveFreqNorms);
        }
        Lucene90SkipWriter.writeImpacts(competitiveFreqNorms, (DataOutput)this.freqNormOut);
        skipBuffer.writeVInt(Math.toIntExact(this.freqNormOut.size()));
        this.freqNormOut.copyTo(skipBuffer);
        this.freqNormOut.reset();
        competitiveFreqNorms.clear();
    }

    static void writeImpacts(CompetitiveImpactAccumulator acc, DataOutput out) throws IOException {
        Collection impacts = acc.getCompetitiveFreqNormPairs();
        Impact previous = new Impact(0, 0L);
        for (Impact impact : impacts) {
            assert (impact.freq > previous.freq);
            assert (Long.compareUnsigned(impact.norm, previous.norm) > 0);
            int freqDelta = impact.freq - previous.freq - 1;
            long normDelta = impact.norm - previous.norm - 1L;
            if (normDelta == 0L) {
                out.writeVInt(freqDelta << 1);
            } else {
                out.writeVInt(freqDelta << 1 | 1);
                out.writeZLong(normDelta);
            }
            previous = impact;
        }
    }
}

