info = {
    "name": "sv",
    "date_order": "YMD",
    "january": [
        "jan",
        "januari"
    ],
    "february": [
        "feb",
        "februari"
    ],
    "march": [
        "mars"
    ],
    "april": [
        "apr",
        "april"
    ],
    "may": [
        "maj"
    ],
    "june": [
        "juni",
        "Jun"
    ],
    "july": [
        "juli",
        "Jul"
    ],
    "august": [
        "aug",
        "augusti"
    ],
    "september": [
        "sep",
        "september",
        "Sept"
    ],
    "october": [
        "okt",
        "oktober"
    ],
    "november": [
        "nov",
        "november"
    ],
    "december": [
        "dec",
        "december"
    ],
    "monday": [
        "mån",
        "måndag",
        "Månd"
    ],
    "tuesday": [
        "tis",
        "tisdag",
        "Tisd"
    ],
    "wednesday": [
        "ons",
        "onsdag",
        "Onsd"
    ],
    "thursday": [
        "tors",
        "torsdag",
        "Torsd"
    ],
    "friday": [
        "fre",
        "fredag",
        "Fred"
    ],
    "saturday": [
        "lör",
        "lördag",
        "Lörd"
    ],
    "sunday": [
        "sön",
        "söndag",
        "Sönd"
    ],
    "am": [
        "fm",
        "förmiddag"
    ],
    "pm": [
        "eftermiddag",
        "em"
    ],
    "year": [
        "år",
        "året"
    ],
    "month": [
        "m",
        "mån",
        "månad",
        "månader",
        "månaden"
    ],
    "week": [
        "v",
        "vecka",
        "veckor"
    ],
    "day": [
        "dag",
        "dagar"
    ],
    "hour": [
        "h",
        "tim",
        "timme",
        "timmar",
        "t"
    ],
    "minute": [
        "m",
        "min",
        "minut",
        "minuter"
    ],
    "second": [
        "s",
        "sek",
        "sekund",
        "sekunder"
    ],
    "relative-type": {
        "0 day ago": [
            "i dag",
            "idag"
        ],
        "0 hour ago": [
            "denna timme"
        ],
        "0 minute ago": [
            "denna minut"
        ],
        "0 month ago": [
            "denna mån",
            "denna månad"
        ],
        "0 second ago": [
            "nu"
        ],
        "0 week ago": [
            "denna v",
            "denna vecka"
        ],
        "0 year ago": [
            "i år"
        ],
        "1 day ago": [
            "i går",
            "igår"
        ],
        "1 month ago": [
            "förra mån",
            "förra månaden"
        ],
        "1 week ago": [
            "förra v",
            "förra veckan"
        ],
        "1 year ago": [
            "i fjol",
            "förra året"
        ],
        "in 1 day": [
            "i morgon",
            "imorgon"
        ],
        "in 1 month": [
            "nästa mån",
            "nästa månad"
        ],
        "in 1 week": [
            "nästa v",
            "nästa vecka"
        ],
        "in 1 year": [
            "nästa år"
        ],
        "2 day ago": [
            "förrgår"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "för (\\d+[.,]?\\d*) d sedan",
            "för (\\d+[.,]?\\d*) dag sedan",
            "för (\\d+[.,]?\\d*) dagar sedan",
            "−(\\d+[.,]?\\d*) d"
        ],
        "\\1 hour ago": [
            "för (\\d+[.,]?\\d*) tim sedan",
            "för (\\d+[.,]?\\d*) timmar sedan",
            "för (\\d+[.,]?\\d*) timme sedan",
            "−(\\d+[.,]?\\d*) h"
        ],
        "\\1 minute ago": [
            "för (\\d+[.,]?\\d*) min sedan",
            "för (\\d+[.,]?\\d*) minut sedan",
            "för (\\d+[.,]?\\d*) minuter sedan",
            "−(\\d+[.,]?\\d*) min"
        ],
        "\\1 month ago": [
            "för (\\d+[.,]?\\d*) mån sedan",
            "för (\\d+[.,]?\\d*) månad sedan",
            "för (\\d+[.,]?\\d*) månader sedan",
            "−(\\d+[.,]?\\d*) mån"
        ],
        "\\1 second ago": [
            "för (\\d+[.,]?\\d*) sek sedan",
            "för (\\d+[.,]?\\d*) sekund sedan",
            "för (\\d+[.,]?\\d*) sekunder sedan",
            "−(\\d+[.,]?\\d*) s"
        ],
        "\\1 week ago": [
            "för (\\d+[.,]?\\d*) v sedan",
            "för (\\d+[.,]?\\d*) vecka sedan",
            "för (\\d+[.,]?\\d*) veckor sedan",
            "−(\\d+[.,]?\\d*) v"
        ],
        "\\1 year ago": [
            "för (\\d+[.,]?\\d*) år sedan",
            "−(\\d+[.,]?\\d*) år"
        ],
        "in \\1 day": [
            "om (\\d+[.,]?\\d*) d",
            "om (\\d+[.,]?\\d*) dag",
            "om (\\d+[.,]?\\d*) dagar"
        ],
        "in \\1 hour": [
            "om (\\d+[.,]?\\d*) tim",
            "om (\\d+[.,]?\\d*) timmar",
            "om (\\d+[.,]?\\d*) timme"
        ],
        "in \\1 minute": [
            "om (\\d+[.,]?\\d*) min",
            "om (\\d+[.,]?\\d*) minut",
            "om (\\d+[.,]?\\d*) minuter"
        ],
        "in \\1 month": [
            "om (\\d+[.,]?\\d*) mån",
            "om (\\d+[.,]?\\d*) månad",
            "om (\\d+[.,]?\\d*) månader"
        ],
        "in \\1 second": [
            "om (\\d+[.,]?\\d*) sek",
            "om (\\d+[.,]?\\d*) sekund",
            "om (\\d+[.,]?\\d*) sekunder"
        ],
        "in \\1 week": [
            "om (\\d+[.,]?\\d*) v",
            "om (\\d+[.,]?\\d*) vecka",
            "om (\\d+[.,]?\\d*) veckor"
        ],
        "in \\1 year": [
            "om (\\d+[.,]?\\d*) år"
        ]
    },
    "locale_specific": {
        "sv-AX": {
            "name": "sv-AX"
        },
        "sv-FI": {
            "name": "sv-FI",
            "date_order": "DMY"
        }
    },
    "skip": [
        "den",
        "på",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "sedan"
    ],
    "in": [
        "om",
        "från nu"
    ],
    "simplifications": [
        {
            "en": "1"
        },
        {
            "två": "2"
        }
    ]
}
