/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(-36, 32, -88) & abs(~ 12)) => ivec3(12, 0, 8)
 * (ivec3(-36, 32, -88) & abs(~ -6)) => ivec3(4, 0, 0)
 * (ivec3(-36, 32, -88) & abs(~ 76)) => ivec3(76, 0, 8)
 * (ivec3(-36, 32, -88) & abs(~ -32)) => ivec3(28, 0, 8)
 * (ivec3(-36, 32, -88) & abs(~ 0)) => ivec3(0, 0, 0)
 * (ivec3(36, 32, 88) & abs(~ 12)) => ivec3(4, 0, 8)
 * (ivec3(36, 32, 88) & abs(~ -6)) => ivec3(4, 0, 0)
 * (ivec3(36, 32, 88) & abs(~ 76)) => ivec3(4, 0, 72)
 * (ivec3(36, 32, 88) & abs(~ -32)) => ivec3(4, 0, 24)
 * (ivec3(36, 32, 88) & abs(~ 0)) => ivec3(0, 0, 0)
 * (ivec3(59, 77, 68) & abs(~ 12)) => ivec3(9, 13, 4)
 * (ivec3(59, 77, 68) & abs(~ -6)) => ivec3(1, 5, 4)
 * (ivec3(59, 77, 68) & abs(~ 76)) => ivec3(9, 77, 68)
 * (ivec3(59, 77, 68) & abs(~ -32)) => ivec3(27, 13, 4)
 * (ivec3(59, 77, 68) & abs(~ 0)) => ivec3(1, 1, 0)
 */
#version 150

void main()
{
  float[all(equal((ivec3(-36, 32, -88) & abs(~ 12)), ivec3(12, 0, 8))) ? 1 : -1] array0;
  float[all(equal((ivec3(-36, 32, -88) & abs(~ -6)), ivec3(4, 0, 0))) ? 1 : -1] array1;
  float[all(equal((ivec3(-36, 32, -88) & abs(~ 76)), ivec3(76, 0, 8))) ? 1 : -1] array2;
  float[all(equal((ivec3(-36, 32, -88) & abs(~ -32)), ivec3(28, 0, 8))) ? 1 : -1] array3;
  float[all(equal((ivec3(-36, 32, -88) & abs(~ 0)), ivec3(0, 0, 0))) ? 1 : -1] array4;
  float[all(equal((ivec3(36, 32, 88) & abs(~ 12)), ivec3(4, 0, 8))) ? 1 : -1] array5;
  float[all(equal((ivec3(36, 32, 88) & abs(~ -6)), ivec3(4, 0, 0))) ? 1 : -1] array6;
  float[all(equal((ivec3(36, 32, 88) & abs(~ 76)), ivec3(4, 0, 72))) ? 1 : -1] array7;
  float[all(equal((ivec3(36, 32, 88) & abs(~ -32)), ivec3(4, 0, 24))) ? 1 : -1] array8;
  float[all(equal((ivec3(36, 32, 88) & abs(~ 0)), ivec3(0, 0, 0))) ? 1 : -1] array9;
  float[all(equal((ivec3(59, 77, 68) & abs(~ 12)), ivec3(9, 13, 4))) ? 1 : -1] array10;
  float[all(equal((ivec3(59, 77, 68) & abs(~ -6)), ivec3(1, 5, 4))) ? 1 : -1] array11;
  float[all(equal((ivec3(59, 77, 68) & abs(~ 76)), ivec3(9, 77, 68))) ? 1 : -1] array12;
  float[all(equal((ivec3(59, 77, 68) & abs(~ -32)), ivec3(27, 13, 4))) ? 1 : -1] array13;
  float[all(equal((ivec3(59, 77, 68) & abs(~ 0)), ivec3(1, 1, 0))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
