/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(38, 35) ^ abs(- 12)) => ivec2(42, 47)
 * (ivec2(38, 35) ^ abs(- -6)) => ivec2(32, 37)
 * (ivec2(38, 35) ^ abs(- 76)) => ivec2(106, 111)
 * (ivec2(38, 35) ^ abs(- -32)) => ivec2(6, 3)
 * (ivec2(38, 35) ^ abs(- 0)) => ivec2(38, 35)
 * (ivec2(64, -9) ^ abs(- 12)) => ivec2(76, -5)
 * (ivec2(64, -9) ^ abs(- -6)) => ivec2(70, -15)
 * (ivec2(64, -9) ^ abs(- 76)) => ivec2(12, -69)
 * (ivec2(64, -9) ^ abs(- -32)) => ivec2(96, -41)
 * (ivec2(64, -9) ^ abs(- 0)) => ivec2(64, -9)
 * (ivec2(64, 9) ^ abs(- 12)) => ivec2(76, 5)
 * (ivec2(64, 9) ^ abs(- -6)) => ivec2(70, 15)
 * (ivec2(64, 9) ^ abs(- 76)) => ivec2(12, 69)
 * (ivec2(64, 9) ^ abs(- -32)) => ivec2(96, 41)
 * (ivec2(64, 9) ^ abs(- 0)) => ivec2(64, 9)
 */
#version 130

void main()
{
  float[all(equal((ivec2(38, 35) ^ abs(- 12)), ivec2(42, 47))) ? 1 : -1] array0;
  float[all(equal((ivec2(38, 35) ^ abs(- -6)), ivec2(32, 37))) ? 1 : -1] array1;
  float[all(equal((ivec2(38, 35) ^ abs(- 76)), ivec2(106, 111))) ? 1 : -1] array2;
  float[all(equal((ivec2(38, 35) ^ abs(- -32)), ivec2(6, 3))) ? 1 : -1] array3;
  float[all(equal((ivec2(38, 35) ^ abs(- 0)), ivec2(38, 35))) ? 1 : -1] array4;
  float[all(equal((ivec2(64, -9) ^ abs(- 12)), ivec2(76, -5))) ? 1 : -1] array5;
  float[all(equal((ivec2(64, -9) ^ abs(- -6)), ivec2(70, -15))) ? 1 : -1] array6;
  float[all(equal((ivec2(64, -9) ^ abs(- 76)), ivec2(12, -69))) ? 1 : -1] array7;
  float[all(equal((ivec2(64, -9) ^ abs(- -32)), ivec2(96, -41))) ? 1 : -1] array8;
  float[all(equal((ivec2(64, -9) ^ abs(- 0)), ivec2(64, -9))) ? 1 : -1] array9;
  float[all(equal((ivec2(64, 9) ^ abs(- 12)), ivec2(76, 5))) ? 1 : -1] array10;
  float[all(equal((ivec2(64, 9) ^ abs(- -6)), ivec2(70, 15))) ? 1 : -1] array11;
  float[all(equal((ivec2(64, 9) ^ abs(- 76)), ivec2(12, 69))) ? 1 : -1] array12;
  float[all(equal((ivec2(64, 9) ^ abs(- -32)), ivec2(96, 41))) ? 1 : -1] array13;
  float[all(equal((ivec2(64, 9) ^ abs(- 0)), ivec2(64, 9))) ? 1 : -1] array14;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
