/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(-36, 32, -88) == ivec3(-36, 32, -88)) => true
 * (ivec3(-36, 32, -88) == ivec3(36, 32, 88)) => false
 * (ivec3(-36, 32, -88) == ivec3(59, 77, 68)) => false
 * (ivec3(36, 32, 88) == ivec3(-36, 32, -88)) => false
 * (ivec3(36, 32, 88) == ivec3(36, 32, 88)) => true
 * (ivec3(36, 32, 88) == ivec3(59, 77, 68)) => false
 * (ivec3(59, 77, 68) == ivec3(-36, 32, -88)) => false
 * (ivec3(59, 77, 68) == ivec3(36, 32, 88)) => false
 * (ivec3(59, 77, 68) == ivec3(59, 77, 68)) => true
 */
#version 120

void main()
{
  float[(ivec3(-36, 32, -88) == ivec3(-36, 32, -88)) == true ? 1 : -1] array0;
  float[(ivec3(-36, 32, -88) == ivec3(36, 32, 88)) == false ? 1 : -1] array1;
  float[(ivec3(-36, 32, -88) == ivec3(59, 77, 68)) == false ? 1 : -1] array2;
  float[(ivec3(36, 32, 88) == ivec3(-36, 32, -88)) == false ? 1 : -1] array3;
  float[(ivec3(36, 32, 88) == ivec3(36, 32, 88)) == true ? 1 : -1] array4;
  float[(ivec3(36, 32, 88) == ivec3(59, 77, 68)) == false ? 1 : -1] array5;
  float[(ivec3(59, 77, 68) == ivec3(-36, 32, -88)) == false ? 1 : -1] array6;
  float[(ivec3(59, 77, 68) == ivec3(36, 32, 88)) == false ? 1 : -1] array7;
  float[(ivec3(59, 77, 68) == ivec3(59, 77, 68)) == true ? 1 : -1] array8;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
