/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.usertune;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.usertune.element.UserTuneElement;

public final class UserTuneManager
extends Manager {
    public static final String USERTUNE_NODE = "http://jabber.org/protocol/tune";
    private static final Map<XMPPConnection, UserTuneManager> INSTANCES = new WeakHashMap<XMPPConnection, UserTuneManager>();
    private final PepManager pepManager;

    public static synchronized UserTuneManager getInstanceFor(XMPPConnection connection) throws SmackException.NotLoggedInException {
        UserTuneManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new UserTuneManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    private UserTuneManager(XMPPConnection connection) {
        super(connection);
        this.pepManager = PepManager.getInstanceFor(connection);
    }

    public void clearUserTune() throws SmackException.NotLoggedInException, PubSubException.NotALeafNodeException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, InterruptedException {
        this.publishUserTune(UserTuneElement.EMPTY_USER_TUNE);
    }

    public void publishUserTune(UserTuneElement userTuneElement) throws SmackException.NotLoggedInException, PubSubException.NotALeafNodeException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, InterruptedException {
        this.pepManager.publish(USERTUNE_NODE, new PayloadItem<UserTuneElement>(userTuneElement));
    }

    public boolean addUserTuneListener(PepEventListener<UserTuneElement> listener) {
        return this.pepManager.addPepEventListener(USERTUNE_NODE, UserTuneElement.class, listener);
    }

    public boolean removeUserTuneListener(PepEventListener<UserTuneElement> listener) {
        return this.pepManager.removePepEventListener(listener);
    }
}

