/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.attributes;

import jadx.plugins.input.java.data.ConstPoolReader;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.JavaClassData;
import jadx.plugins.input.java.data.attributes.IJavaAttribute;
import jadx.plugins.input.java.data.attributes.IJavaAttributeReader;
import jadx.plugins.input.java.data.attributes.JavaAttrStorage;
import jadx.plugins.input.java.data.attributes.JavaAttrType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributesReader {
    private static final Logger LOG = LoggerFactory.getLogger(AttributesReader.class);
    private final JavaClassData clsData;
    private final ConstPoolReader constPool;
    private final Map<Integer, JavaAttrType<?>> attrCache = new HashMap(JavaAttrType.size());

    public AttributesReader(JavaClassData clsData, ConstPoolReader constPoolReader) {
        this.clsData = clsData;
        this.constPool = constPoolReader;
    }

    public JavaAttrStorage load(DataReader reader) {
        int attributesCount = reader.readU2();
        if (attributesCount == 0) {
            return JavaAttrStorage.EMPTY;
        }
        JavaAttrStorage storage = new JavaAttrStorage();
        for (int i = 0; i < attributesCount; ++i) {
            this.readAndAdd(storage, reader);
        }
        return storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndAdd(JavaAttrStorage storage, DataReader reader) {
        int nameIdx = reader.readU2();
        int len = reader.readU4();
        int end = reader.getOffset() + len;
        try {
            JavaAttrType<?> attrType = this.resolveAttrReader(nameIdx);
            if (attrType == null) {
                return;
            }
            IJavaAttributeReader attrReader = attrType.getReader();
            if (attrReader == null) {
                return;
            }
            IJavaAttribute attrValue = attrReader.read(this.clsData, reader);
            if (attrValue != null) {
                storage.add(attrType, attrValue);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse attribute: {}", (Object)this.constPool.getUtf8(nameIdx), (Object)e);
        }
        finally {
            reader.absPos(end);
        }
    }

    @Nullable
    public <T extends IJavaAttribute> T loadOne(JavaAttrType<T> type, DataReader reader) {
        int attributesCount = reader.readU2();
        if (attributesCount == 0) {
            return null;
        }
        for (int i = 0; i < attributesCount; ++i) {
            IJavaAttribute attr = this.readType(type, reader);
            if (attr == null) continue;
            return (T)attr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IJavaAttribute readType(JavaAttrType<?> type, DataReader reader) {
        int nameIdx = reader.readU2();
        int len = reader.readU4();
        int end = reader.getOffset() + len;
        try {
            JavaAttrType<?> attrType = this.resolveAttrReader(nameIdx);
            if (attrType == null || attrType != type) {
                IJavaAttribute iJavaAttribute = null;
                return iJavaAttribute;
            }
            IJavaAttribute iJavaAttribute = attrType.getReader().read(this.clsData, reader);
            return iJavaAttribute;
        }
        catch (Exception e) {
            LOG.error("Failed to parse attribute: {}", (Object)this.constPool.getUtf8(nameIdx), (Object)e);
            IJavaAttribute iJavaAttribute = null;
            return iJavaAttribute;
        }
        finally {
            reader.absPos(end);
        }
    }

    private JavaAttrType<?> resolveAttrReader(int nameIdx) {
        return this.attrCache.computeIfAbsent(nameIdx, idx -> {
            String attrName = this.constPool.getUtf8((int)idx);
            JavaAttrType<?> attrType = JavaAttrType.byName(attrName);
            if (attrType == null) {
                LOG.warn("Unknown java class attribute type: {}", (Object)attrName);
                return null;
            }
            return attrType;
        });
    }
}

