/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.config;

import com.beust.jcommander.ParametersDelegate;
import de.rub.nds.tlsattacker.attacks.config.AttackConfig;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.CiphersuiteDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ClientDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ProtocolVersionDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.StarttlsDelegate;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;

public class EarlyCCSCommandConfig
extends AttackConfig {
    public static final String ATTACK_COMMAND = "early_ccs";
    @ParametersDelegate
    private ClientDelegate clientDelegate = new ClientDelegate();
    @ParametersDelegate
    private CiphersuiteDelegate ciphersuiteDelegate = new CiphersuiteDelegate();
    @ParametersDelegate
    private ProtocolVersionDelegate protocolVersionDelegate = new ProtocolVersionDelegate();
    @ParametersDelegate
    private StarttlsDelegate starttlsDelegate = new StarttlsDelegate();

    public EarlyCCSCommandConfig(GeneralDelegate delegate) {
        super(delegate);
        this.addDelegate(this.clientDelegate);
        this.addDelegate(this.ciphersuiteDelegate);
        this.addDelegate(this.protocolVersionDelegate);
        this.addDelegate(this.starttlsDelegate);
    }

    @Override
    public boolean isExecuteAttack() {
        return false;
    }

    @Override
    public Config createConfig() {
        Config config = super.createConfig();
        config.setAddRenegotiationInfoExtension(true);
        config.setAddServerNameIndicationExtension(true);
        config.setAddSignatureAndHashAlgorithmsExtension(true);
        config.setQuickReceive(true);
        config.setStopActionsAfterFatal(true);
        config.setStopReceivingAfterFatal(true);
        config.setEarlyStop(true);
        boolean containsEc = false;
        for (CipherSuite suite : config.getDefaultClientSupportedCiphersuites()) {
            KeyExchangeAlgorithm keyExchangeAlgorithm = AlgorithmResolver.getKeyExchangeAlgorithm(suite);
            if (keyExchangeAlgorithm == null || !keyExchangeAlgorithm.name().toUpperCase().contains("EC")) continue;
            containsEc = true;
            break;
        }
        config.setAddECPointFormatExtension(containsEc);
        config.setAddEllipticCurveExtension(containsEc);
        return config;
    }
}

