/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFovf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ANGLELEFT;
    public static final int ANGLERIGHT;
    public static final int ANGLEUP;
    public static final int ANGLEDOWN;

    public XrFovf(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFovf.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float angleLeft() {
        return XrFovf.nangleLeft(this.address());
    }

    public float angleRight() {
        return XrFovf.nangleRight(this.address());
    }

    public float angleUp() {
        return XrFovf.nangleUp(this.address());
    }

    public float angleDown() {
        return XrFovf.nangleDown(this.address());
    }

    public XrFovf angleLeft(float value) {
        XrFovf.nangleLeft(this.address(), value);
        return this;
    }

    public XrFovf angleRight(float value) {
        XrFovf.nangleRight(this.address(), value);
        return this;
    }

    public XrFovf angleUp(float value) {
        XrFovf.nangleUp(this.address(), value);
        return this;
    }

    public XrFovf angleDown(float value) {
        XrFovf.nangleDown(this.address(), value);
        return this;
    }

    public XrFovf set(float angleLeft, float angleRight, float angleUp, float angleDown) {
        this.angleLeft(angleLeft);
        this.angleRight(angleRight);
        this.angleUp(angleUp);
        this.angleDown(angleDown);
        return this;
    }

    public XrFovf set(XrFovf src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFovf malloc() {
        return (XrFovf)XrFovf.wrap(XrFovf.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrFovf calloc() {
        return (XrFovf)XrFovf.wrap(XrFovf.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrFovf create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrFovf)XrFovf.wrap(XrFovf.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrFovf create(long address) {
        return (XrFovf)XrFovf.wrap(XrFovf.class, (long)address);
    }

    @Nullable
    public static XrFovf createSafe(long address) {
        return address == 0L ? null : (XrFovf)XrFovf.wrap(XrFovf.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrFovf.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrFovf.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrFovf.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFovf.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrFovf.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrFovf.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrFovf.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrFovf malloc(MemoryStack stack) {
        return (XrFovf)XrFovf.wrap(XrFovf.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrFovf calloc(MemoryStack stack) {
        return (XrFovf)XrFovf.wrap(XrFovf.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrFovf.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrFovf.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nangleLeft(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ANGLELEFT);
    }

    public static float nangleRight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ANGLERIGHT);
    }

    public static float nangleUp(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ANGLEUP);
    }

    public static float nangleDown(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ANGLEDOWN);
    }

    public static void nangleLeft(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ANGLELEFT, value);
    }

    public static void nangleRight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ANGLERIGHT, value);
    }

    public static void nangleUp(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ANGLEUP, value);
    }

    public static void nangleDown(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ANGLEDOWN, value);
    }

    static {
        Struct.Layout layout = XrFovf.__struct((Struct.Member[])new Struct.Member[]{XrFovf.__member((int)4), XrFovf.__member((int)4), XrFovf.__member((int)4), XrFovf.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ANGLELEFT = layout.offsetof(0);
        ANGLERIGHT = layout.offsetof(1);
        ANGLEUP = layout.offsetof(2);
        ANGLEDOWN = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrFovf, Buffer>
    implements NativeResource {
        private static final XrFovf ELEMENT_FACTORY = XrFovf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrFovf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float angleLeft() {
            return XrFovf.nangleLeft(this.address());
        }

        public float angleRight() {
            return XrFovf.nangleRight(this.address());
        }

        public float angleUp() {
            return XrFovf.nangleUp(this.address());
        }

        public float angleDown() {
            return XrFovf.nangleDown(this.address());
        }

        public Buffer angleLeft(float value) {
            XrFovf.nangleLeft(this.address(), value);
            return this;
        }

        public Buffer angleRight(float value) {
            XrFovf.nangleRight(this.address(), value);
            return this;
        }

        public Buffer angleUp(float value) {
            XrFovf.nangleUp(this.address(), value);
            return this;
        }

        public Buffer angleDown(float value) {
            XrFovf.nangleDown(this.address(), value);
            return this;
        }
    }
}

