/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer.tableviewer;

import com.ca.commons.cbutil.CBCache;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.search.SearchExecute;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeTableModel;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeType;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValue;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValueCellEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;

public class SmartPopupTableTool
extends JPopupMenu
implements ActionListener {
    JMenuItem delete;
    JMenuItem newValue;
    JMenuItem findDN;
    JMenuItem makeNaming;
    JMenuItem removeNaming;
    JXplorer jx;
    JTable table;
    AttributeTableModel model;
    String attributeName = null;
    int currentRow;
    AttributeValue currentValue;
    AttributeType currentType;
    DN currentDN = null;
    AttributeValueCellEditor cellEditor = null;
    private static Logger log = Logger.getLogger(SmartPopupTableTool.class.getName());

    public SmartPopupTableTool(JTable t, AttributeTableModel m, JXplorer jxplorer) {
        this.jx = jxplorer;
        this.table = t;
        this.model = m;
        this.newValue = new JMenuItem(CBIntText.get("Add Another Value"));
        this.add(this.newValue);
        this.delete = new JMenuItem(CBIntText.get("Delete Value"));
        this.add(this.delete);
        this.makeNaming = new JMenuItem(CBIntText.get("Make Naming Value"));
        this.add(this.makeNaming);
        this.removeNaming = new JMenuItem(CBIntText.get("Remove Naming Value"));
        this.add(this.removeNaming);
        this.add(new JSeparator());
        this.findDN = new JMenuItem(CBIntText.get("Find DN"));
        this.add(this.findDN);
        this.removeNaming.setVisible(false);
        this.findDN.addActionListener(this);
        this.newValue.addActionListener(this);
        this.delete.addActionListener(this);
        this.makeNaming.addActionListener(this);
        this.removeNaming.addActionListener(this);
        this.setVisible(false);
    }

    public void registerCurrentRow(AttributeType type, AttributeValue value, int row, RDN currentRDN) {
        this.currentType = type;
        this.currentValue = value;
        this.currentRow = row;
        if (this.currentType.toString().equalsIgnoreCase("objectclass")) {
            this.newValue.setEnabled(false);
            this.delete.setEnabled(false);
        } else {
            this.newValue.setEnabled(true);
            this.delete.setEnabled(true);
        }
        if (value.isNaming()) {
            if (currentRDN != null) {
                if (currentRDN.size() > 1) {
                    this.removeNaming.setVisible(true);
                } else {
                    this.removeNaming.setVisible(false);
                }
            }
            this.makeNaming.setVisible(false);
        } else {
            if (currentRDN != null) {
                if (currentRDN.toString().indexOf(type.toString() + "=") > -1) {
                    this.makeNaming.setVisible(false);
                } else if (this.currentType.isMandatory()) {
                    this.makeNaming.setVisible(true);
                } else {
                    this.makeNaming.setVisible(false);
                }
            }
            this.removeNaming.setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent ev) {
        this.setVisible(false);
        Object eventSource = ev.getSource();
        if (eventSource == this.newValue) {
            this.cellEditor.stopCellEditing();
            this.newValue();
        } else if (eventSource == this.delete) {
            this.delete();
        } else if (eventSource == this.removeNaming) {
            this.removeRDNComponent();
        } else if (eventSource == this.makeNaming) {
            this.addRDNComponent();
        } else if (eventSource == this.findDN) {
            this.findDNComponent();
        } else {
            log.log(Level.WARNING, "Unknown event in popup menu:\n", ev);
        }
        this.repaint();
    }

    public void findDNComponent() {
        if ("".equals(this.currentValue.getStringValue())) {
            this.jx.getSearchTree().clearTree();
            this.jx.getTreeTabPane().setSelectedComponent(this.jx.getResultsPanel());
            return;
        }
        String filter = "(objectclass=*)";
        DN dn = new DN(this.currentValue.getStringValue());
        String aliasOption = "always";
        log.info("Setting search alias option to: [" + aliasOption + "]");
        JXplorer.setProperty("option.ldap.searchAliasBehaviour", aliasOption);
        this.jx.getSearchBroker().setGUIQuiet(true);
        SearchExecute.run(this.jx.getSearchTree(), dn, filter, new String[]{"objectClass"}, 0, this.jx.getSearchBroker());
        this.jx.getTreeTabPane().setSelectedComponent(this.jx.getResultsPanel());
    }

    public void newValue() {
        AttributeValue newVal;
        int type = this.currentType.isMandatory() ? 1 : 0;
        String attName = this.currentType.getValue();
        if (this.currentValue.isBinary()) {
            newVal = new AttributeValue(attName, null);
            newVal.setBinary(true);
        } else {
            newVal = new AttributeValue(attName, "");
        }
        this.model.addAttribute(attName, newVal, type, this.currentRow + 1);
        this.model.fireChange();
    }

    public void delete() {
        this.model.deleteAttribute(this.currentType.getValue(), this.currentRow);
        if (this.currentValue.isBinary()) {
            this.currentValue.setValue(null);
        }
        this.model.fireChange();
        if (this.currentType.getValue().equalsIgnoreCase("jpegPhoto")) {
            CBCache.cleanCache(this.currentDN.toString());
        }
    }

    public void removeRDNComponent() {
        if (this.model.getRDNSize() == 1) {
            CBUtility.error(CBIntText.get("Cannot remove the last naming component!"));
        } else {
            this.model.removeNamingComponent(this.currentType, this.currentValue);
        }
    }

    public void addRDNComponent() {
        if (this.currentValue.isBinary()) {
            CBUtility.error(CBIntText.get("Binary naming components are not supported."));
        } else if (this.currentValue.isEmpty()) {
            CBUtility.error(CBIntText.get("A Naming Component must have an actual value."));
        } else {
            this.model.addNamingComponent(this.currentType, this.currentValue);
        }
    }

    public void setDN(DN dn) {
        this.currentDN = dn;
    }

    public void registerCellEditor(AttributeValueCellEditor myEditor) {
        this.cellEditor = myEditor;
    }
}

